/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.message.request;

import com.google.common.base.MoreObjects;
import jakarta.mail.Flags;
import java.io.Closeable;
import java.io.IOException;
import java.util.Date;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.message.Literal;
import org.apache.james.imap.message.request.AbstractImapRequest;

public class AppendRequest
extends AbstractImapRequest
implements Closeable {
    private final String mailboxName;
    private final Flags flags;
    private final Date datetime;
    private final Literal message;

    public AppendRequest(String mailboxName, Flags flags, Date datetime, Literal message, Tag tag) {
        super(tag, ImapConstants.APPEND_COMMAND);
        this.mailboxName = mailboxName;
        this.flags = flags;
        this.datetime = datetime;
        this.message = message;
    }

    public Date getDatetime() {
        return this.datetime;
    }

    public Flags getFlags() {
        return this.flags;
    }

    public String getMailboxName() {
        return this.mailboxName;
    }

    public Literal getMessage() {
        return this.message;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mailboxName", (Object)this.mailboxName).add("flags", (Object)this.flags).add("datetime", (Object)this.datetime).add("message", (Object)this.message).toString();
    }

    @Override
    public void close() throws IOException {
        if (this.message instanceof Closeable) {
            ((Closeable)((Object)this.message)).close();
        }
    }
}

