/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.ldap;

import com.github.fge.lambdas.Throwing;
import com.github.fge.lambdas.functions.ThrowingFunction;
import com.google.common.collect.ImmutableList;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.FailoverServerSet;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.SingleServerSet;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.james.user.ldap.LdapRepositoryConfiguration;

public class LDAPConnectionFactory {
    private static final TrustManager DUMMY_TRUST_MANAGER = new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }
    };
    private final LdapRepositoryConfiguration configuration;
    private final LDAPConnectionPool ldapConnectionPool;

    public LDAPConnectionFactory(LdapRepositoryConfiguration configuration) throws LDAPException {
        this.configuration = configuration;
        LDAPConnectionOptions connectionOptions = new LDAPConnectionOptions();
        connectionOptions.setConnectTimeoutMillis(configuration.getConnectionTimeout());
        connectionOptions.setResponseTimeoutMillis((long)configuration.getReadTimeout());
        SimpleBindRequest bindRequest = new SimpleBindRequest(configuration.getPrincipal(), configuration.getCredentials());
        List serverSets = (List)configuration.getLdapHosts().stream().map(this.toSingleServerSet(connectionOptions, (BindRequest)bindRequest)).collect(ImmutableList.toImmutableList());
        FailoverServerSet failoverServerSet = new FailoverServerSet(serverSets);
        this.ldapConnectionPool = new LDAPConnectionPool((ServerSet)failoverServerSet, (BindRequest)bindRequest, configuration.getPoolSize());
        this.ldapConnectionPool.setRetryFailedOperationsDueToInvalidConnections(true);
        this.ldapConnectionPool.setMaxWaitTimeMillis((long)configuration.getMaxWaitTime());
    }

    private ThrowingFunction<URI, SingleServerSet> toSingleServerSet(LDAPConnectionOptions connectionOptions, BindRequest bindRequest) {
        return Throwing.function(uri -> new SingleServerSet(uri.getHost(), uri.getPort(), this.supportLDAPS((URI)uri), connectionOptions, bindRequest, null));
    }

    private SocketFactory supportLDAPS(URI uri) throws KeyManagementException, NoSuchAlgorithmException {
        if (uri.getScheme().equals("ldaps")) {
            if (this.configuration.isTrustAllCerts()) {
                SSLContext context = SSLContext.getInstance("TLSv1.2");
                context.init(null, new TrustManager[]{DUMMY_TRUST_MANAGER}, null);
                return context.getSocketFactory();
            }
            return SSLSocketFactory.getDefault();
        }
        return null;
    }

    public LDAPConnectionPool getLdapConnectionPool() {
        return this.ldapConnectionPool;
    }
}

