/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.apache.james.events.DispatchingFailureGroup;
import org.apache.james.mailbox.events.GenericGroup;

public class Group {
    public static Group deserialize(String serializedGroup) throws GroupDeserializationException {
        try {
            Preconditions.checkNotNull(serializedGroup, "A serialized group can not be null");
            Preconditions.checkArgument(!Strings.isNullOrEmpty(serializedGroup), "A serialized group can not be empty");
            if (serializedGroup.startsWith(GenericGroup.class.getName() + "-")) {
                return new GenericGroup(serializedGroup.substring(GenericGroup.class.getName().length() + 1));
            }
            if (serializedGroup.startsWith(DispatchingFailureGroup.class.getName() + "-")) {
                return DispatchingFailureGroup.from(serializedGroup);
            }
            Class<?> groupClass = Class.forName(serializedGroup);
            return Group.instantiateGroup(groupClass);
        }
        catch (Exception e) {
            throw new GroupDeserializationException(e);
        }
    }

    private static Group instantiateGroup(Class<?> aClass) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Preconditions.checkArgument(Group.class.isAssignableFrom(aClass), "The supplied class is not a group: %s", (Object)aClass.getName());
        return (Group)aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public String asString() {
        return this.getClass().getName();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.getClass().equals(o.getClass());
    }

    public int hashCode() {
        return Objects.hash(this.getClass());
    }

    public static class GroupDeserializationException
    extends Exception {
        GroupDeserializationException(Throwable cause) {
            super(cause);
        }
    }
}

