/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.api.handler;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.james.protocols.api.BaseRequest;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.CommandHandler;
import org.apache.james.protocols.api.handler.ExtensibleHandler;
import org.apache.james.protocols.api.handler.LineHandler;
import org.apache.james.protocols.api.handler.ProtocolHandlerResultHandler;
import org.apache.james.protocols.api.handler.WiringException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandDispatcher<SessionT extends ProtocolSession>
implements ExtensibleHandler,
LineHandler<SessionT> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandDispatcher.class);
    private final HashMap<String, List<CommandHandler<SessionT>>> commandHandlerMap = new HashMap();
    private final List<ProtocolHandlerResultHandler<Response, SessionT>> rHandlers = new ArrayList<ProtocolHandlerResultHandler<Response, SessionT>>();
    private final Collection<String> mandatoryCommands;

    public CommandDispatcher(Collection<String> mandatoryCommands) {
        this.mandatoryCommands = mandatoryCommands;
    }

    public CommandDispatcher() {
        this(Collections.emptyList());
    }

    protected void addToMap(String commandName, CommandHandler<SessionT> cmdHandler) {
        List<CommandHandler<SessionT>> handlers = this.commandHandlerMap.get(commandName);
        if (handlers == null) {
            handlers = new ArrayList<CommandHandler<SessionT>>();
            this.commandHandlerMap.put(commandName, handlers);
        }
        handlers.add(cmdHandler);
    }

    protected List<CommandHandler<SessionT>> getCommandHandlers(String command, ProtocolSession session) {
        if (command == null) {
            return null;
        }
        LOGGER.debug("Lookup command handler for command: {}", (Object)command);
        List<CommandHandler<SessionT>> handlers = this.commandHandlerMap.get(command);
        if (handlers == null) {
            handlers = this.commandHandlerMap.get(this.getUnknownCommandHandlerIdentifier());
        }
        return handlers;
    }

    public void wireExtensions(Class interfaceName, List extensions) throws WiringException {
        if (interfaceName.equals(ProtocolHandlerResultHandler.class)) {
            this.rHandlers.addAll(extensions);
        }
        if (interfaceName.equals(CommandHandler.class)) {
            for (Object extension : extensions) {
                CommandHandler handler = (CommandHandler)extension;
                Collection<String> implCmds = handler.getImplCommands();
                for (String implCmd : implCmds) {
                    String commandName = implCmd.trim().toUpperCase(Locale.US);
                    this.addToMap(commandName, handler);
                }
            }
            if (this.commandHandlerMap.size() < 1) {
                throw new WiringException("No commandhandlers configured");
            }
            for (String cmd : this.mandatoryCommands) {
                if (this.commandHandlerMap.containsKey(cmd)) continue;
                throw new WiringException("No commandhandlers configured for mandatory command " + cmd);
            }
        }
    }

    @Override
    public Response onLine(SessionT session, ByteBuffer line) {
        Request request;
        try {
            request = this.parseRequest(session, line);
            if (request == null) {
                return null;
            }
        }
        catch (Exception e) {
            LOGGER.debug("Unable to parse request", (Throwable)e);
            return session.newFatalErrorResponse();
        }
        try {
            return this.dispatchCommandHandlers(session, request);
        }
        catch (Exception e) {
            LOGGER.error("Error dispatching command for request {}", (Object)request.getCommand(), (Object)e);
            return session.newFatalErrorResponse();
        }
    }

    protected Response dispatchCommandHandlers(SessionT session, Request request) {
        LOGGER.debug("{} received: {}", (Object)this.getClass().getName(), (Object)request.getCommand());
        List<CommandHandler<SessionT>> commandHandlers = this.getCommandHandlers(request.getCommand(), (ProtocolSession)session);
        if (commandHandlers == null) {
            return session.newCommandNotFoundErrorResponse();
        }
        for (CommandHandler<SessionT> commandHandler : commandHandlers) {
            long executionTime;
            long start = System.currentTimeMillis();
            Response response = commandHandler.onCommand(session, request);
            if (response == null || (response = this.executeResultHandlers(session, response, executionTime = System.currentTimeMillis() - start, commandHandler, this.rHandlers.iterator())) == null) continue;
            return response;
        }
        return null;
    }

    private Response executeResultHandlers(SessionT session, Response responseFuture, long executionTime, CommandHandler<SessionT> cHandler, Iterator<ProtocolHandlerResultHandler<Response, SessionT>> resultHandlers) {
        if (resultHandlers.hasNext()) {
            responseFuture = resultHandlers.next().onResponse((ProtocolSession)session, responseFuture, executionTime, cHandler);
            return this.executeResultHandlers(session, responseFuture, executionTime, cHandler, resultHandlers);
        }
        return responseFuture;
    }

    protected Request parseRequest(SessionT session, ByteBuffer buffer) throws Exception {
        String curCommandName;
        byte[] line;
        String curCommandArgument = null;
        if (buffer.hasArray()) {
            line = buffer.array();
        } else {
            line = new byte[buffer.remaining()];
            buffer.get(line);
        }
        String cmdString = new String(line, session.getCharset().name()).trim();
        int spaceIndex = cmdString.indexOf(" ");
        if (spaceIndex > 0) {
            curCommandName = cmdString.substring(0, spaceIndex);
            curCommandArgument = cmdString.substring(spaceIndex + 1);
        } else {
            curCommandName = cmdString;
        }
        curCommandName = curCommandName.toUpperCase(Locale.US);
        return new BaseRequest(curCommandName, curCommandArgument);
    }

    @Override
    public List<Class<?>> getMarkerInterfaces() {
        LinkedList res = new LinkedList();
        res.add(CommandHandler.class);
        res.add(ProtocolHandlerResultHandler.class);
        return res;
    }

    protected String getUnknownCommandHandlerIdentifier() {
        return "UNKNOWN_CMD";
    }
}

