/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.TypeTokens;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import com.google.common.primitives.Bytes;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.james.backends.cassandra.init.CassandraTypesProvider;
import org.apache.james.backends.cassandra.init.configuration.CassandraConsistenciesConfiguration;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.cassandra.mail.MessageAttachmentRepresentation;
import org.apache.james.mailbox.cassandra.mail.MessageRepresentation;
import org.apache.james.mailbox.cassandra.table.CassandraMessageV3Table;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.ByteContent;
import org.apache.james.mailbox.model.Cid;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.impl.Properties;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public class CassandraMessageDAOV3 {
    public static final long DEFAULT_LONG_VALUE = 0L;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final TypeToken<Map<String, String>> MAP_OF_STRING = TypeTokens.mapOf(String.class, String.class);
    private static final TypeCodec<Map<String, String>> MAP_OF_STRINGS_CODEC = CodecRegistry.DEFAULT_INSTANCE.codecFor((DataType)DataType.frozenMap((DataType)DataType.text(), (DataType)DataType.text()), MAP_OF_STRING);
    private static final TypeToken<List<String>> LIST_OF_STRINGS = TypeTokens.listOf(String.class);
    private static final TypeCodec<List<String>> LIST_OF_STRINGS_CODEC = CodecRegistry.DEFAULT_INSTANCE.codecFor((DataType)DataType.frozenList((DataType)DataType.text()), LIST_OF_STRINGS);
    private static final TypeToken<List<UDTValue>> LIST_OF_UDT = TypeTokens.listOf(UDTValue.class);
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final CassandraTypesProvider typesProvider;
    private final BlobStore blobStore;
    private final BlobId.Factory blobIdFactory;
    private final PreparedStatement insert;
    private final PreparedStatement delete;
    private final PreparedStatement select;
    private final PreparedStatement listBlobs;
    private final Cid.CidParser cidParser;
    private final ConsistencyLevel consistencyLevel;

    @Inject
    public CassandraMessageDAOV3(Session session, CassandraTypesProvider typesProvider, BlobStore blobStore, BlobId.Factory blobIdFactory, CassandraConsistenciesConfiguration consistenciesConfiguration) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.consistencyLevel = consistenciesConfiguration.getRegular();
        this.typesProvider = typesProvider;
        this.blobStore = blobStore;
        this.blobIdFactory = blobIdFactory;
        this.insert = this.prepareInsert(session);
        this.delete = this.prepareDelete(session);
        this.select = this.prepareSelect(session);
        this.listBlobs = this.prepareSelectBlobs(session);
        this.cidParser = Cid.parser().relaxed();
    }

    private PreparedStatement prepareSelect(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select().from("messageV3").where(QueryBuilder.eq((String)"messageId", (Object)QueryBuilder.bindMarker((String)"messageId"))));
    }

    private PreparedStatement prepareSelectBlobs(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"headerContent", "bodyContent"}).from("messageV3"));
    }

    private PreparedStatement prepareInsert(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.update((String)"messageV3").with(QueryBuilder.set((String)"internalDate", (Object)QueryBuilder.bindMarker((String)"internalDate"))).and(QueryBuilder.set((String)"bodyStartOctet", (Object)QueryBuilder.bindMarker((String)"bodyStartOctet"))).and(QueryBuilder.set((String)"fullContentOctets", (Object)QueryBuilder.bindMarker((String)"fullContentOctets"))).and(QueryBuilder.set((String)"bodyOctets", (Object)QueryBuilder.bindMarker((String)"bodyOctets"))).and(QueryBuilder.set((String)"bodyContent", (Object)QueryBuilder.bindMarker((String)"bodyContent"))).and(QueryBuilder.set((String)"headerContent", (Object)QueryBuilder.bindMarker((String)"headerContent"))).and(QueryBuilder.set((String)"contentDescription", (Object)QueryBuilder.bindMarker((String)"contentDescription"))).and(QueryBuilder.set((String)"contentDispositionType", (Object)QueryBuilder.bindMarker((String)"contentDispositionType"))).and(QueryBuilder.set((String)"mediaType", (Object)QueryBuilder.bindMarker((String)"mediaType"))).and(QueryBuilder.set((String)"subType", (Object)QueryBuilder.bindMarker((String)"subType"))).and(QueryBuilder.set((String)"contentId", (Object)QueryBuilder.bindMarker((String)"contentId"))).and(QueryBuilder.set((String)"contentMd5", (Object)QueryBuilder.bindMarker((String)"contentMd5"))).and(QueryBuilder.set((String)"contentTransferEncoding", (Object)QueryBuilder.bindMarker((String)"contentTransferEncoding"))).and(QueryBuilder.set((String)"contentLocation", (Object)QueryBuilder.bindMarker((String)"contentLocation"))).and(QueryBuilder.set((String)"contentLanguage", (Object)QueryBuilder.bindMarker((String)"contentLanguage"))).and(QueryBuilder.set((String)"contentDispositionParameters", (Object)QueryBuilder.bindMarker((String)"contentDispositionParameters"))).and(QueryBuilder.set((String)"contentTypeParameters", (Object)QueryBuilder.bindMarker((String)"contentTypeParameters"))).and(QueryBuilder.set((String)"textualLineCount", (Object)QueryBuilder.bindMarker((String)"textualLineCount"))).and(QueryBuilder.prependAll((String)"attachments", (BindMarker)QueryBuilder.bindMarker((String)"attachments"))).where(QueryBuilder.eq((String)"messageId", (Object)QueryBuilder.bindMarker((String)"messageId"))));
    }

    private PreparedStatement prepareDelete(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("messageV3").where(QueryBuilder.eq((String)"messageId", (Object)QueryBuilder.bindMarker((String)"messageId"))));
    }

    public Mono<Tuple2<BlobId, BlobId>> save(MailboxMessage message) throws MailboxException {
        return this.saveContent(message).flatMap(pair -> this.cassandraAsyncExecutor.executeVoid((Statement)this.boundWriteStatement(message, (Tuple2<BlobId, BlobId>)pair)).thenReturn(pair));
    }

    public Mono<Void> save(MessageRepresentation message) {
        CassandraMessageId messageId = (CassandraMessageId)message.getMessageId();
        BoundStatement boundStatement = this.insert.bind().setUUID("messageId", messageId.get()).setTimestamp("internalDate", message.getInternalDate()).setInt("bodyStartOctet", message.getBodyStartOctet().intValue()).setLong("fullContentOctets", message.getSize().longValue()).setLong("bodyOctets", message.getSize() - (long)message.getBodyStartOctet().intValue()).setString("bodyContent", message.getBodyId().asString()).setString("headerContent", message.getHeaderId().asString()).setLong("textualLineCount", Optional.ofNullable(message.getProperties().getTextualLineCount()).orElse(0L).longValue()).setString("contentDescription", message.getProperties().getContentDescription()).setString("contentDispositionType", message.getProperties().getContentDispositionType()).setString("mediaType", message.getProperties().getMediaType()).setString("subType", message.getProperties().getSubType()).setString("contentId", message.getProperties().getContentID()).setString("contentMd5", message.getProperties().getContentMD5()).setString("contentTransferEncoding", message.getProperties().getContentTransferEncoding()).setString("contentLocation", message.getProperties().getContentLocation()).setList("contentLanguage", message.getProperties().getContentLanguage()).setMap("contentDispositionParameters", message.getProperties().getContentDispositionParameters()).setMap("contentTypeParameters", message.getProperties().getContentTypeParameters());
        if (message.getAttachments().isEmpty()) {
            boundStatement.unset("attachments");
        } else {
            boundStatement.setList("attachments", this.buildAttachmentUdt(message.getAttachments()));
        }
        return this.cassandraAsyncExecutor.executeVoid((Statement)boundStatement);
    }

    private Mono<Tuple2<BlobId, BlobId>> saveContent(final MailboxMessage message) throws MailboxException {
        try {
            byte[] headerContent = IOUtils.toByteArray((InputStream)message.getHeaderContent());
            ByteSource bodyByteSource = new ByteSource(){

                public InputStream openStream() {
                    try {
                        return message.getBodyContent();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                public long size() {
                    return message.getBodyOctets();
                }
            };
            Mono headerFuture = Mono.from((Publisher)this.blobStore.save(this.blobStore.getDefaultBucketName(), headerContent, BlobStore.StoragePolicy.SIZE_BASED));
            Mono bodyFuture = Mono.from((Publisher)this.blobStore.save(this.blobStore.getDefaultBucketName(), bodyByteSource, BlobStore.StoragePolicy.LOW_COST));
            return headerFuture.zipWith(bodyFuture);
        }
        catch (IOException e) {
            throw new MailboxException("Error saving mail content", (Throwable)e);
        }
    }

    private BoundStatement boundWriteStatement(MailboxMessage message, Tuple2<BlobId, BlobId> pair) {
        CassandraMessageId messageId = (CassandraMessageId)message.getMessageId();
        BoundStatement boundStatement = this.insert.bind().setUUID("messageId", messageId.get()).setTimestamp("internalDate", message.getInternalDate()).setInt("bodyStartOctet", (int)message.getHeaderOctets()).setLong("fullContentOctets", message.getFullContentOctets()).setLong("bodyOctets", message.getBodyOctets()).setString("bodyContent", ((BlobId)pair.getT2()).asString()).setString("headerContent", ((BlobId)pair.getT1()).asString()).setLong("textualLineCount", Optional.ofNullable(message.getTextualLineCount()).orElse(0L).longValue()).setString("contentDescription", message.getProperties().getContentDescription()).setString("contentDispositionType", message.getProperties().getContentDispositionType()).setString("mediaType", message.getProperties().getMediaType()).setString("subType", message.getProperties().getSubType()).setString("contentId", message.getProperties().getContentID()).setString("contentMd5", message.getProperties().getContentMD5()).setString("contentTransferEncoding", message.getProperties().getContentTransferEncoding()).setString("contentLocation", message.getProperties().getContentLocation()).setList("contentLanguage", message.getProperties().getContentLanguage()).setMap("contentDispositionParameters", message.getProperties().getContentDispositionParameters()).setMap("contentTypeParameters", message.getProperties().getContentTypeParameters());
        if (message.getAttachments().isEmpty()) {
            boundStatement.unset("attachments");
        } else {
            boundStatement.setList("attachments", this.buildAttachmentUdt(message));
        }
        return boundStatement;
    }

    private ImmutableList<UDTValue> buildAttachmentUdt(MailboxMessage message) {
        return (ImmutableList)message.getAttachments().stream().map(this::toUDT).collect(ImmutableList.toImmutableList());
    }

    private ImmutableList<UDTValue> buildAttachmentUdt(List<MessageAttachmentRepresentation> attachments) {
        return (ImmutableList)attachments.stream().map(this::toUDT).collect(ImmutableList.toImmutableList());
    }

    private UDTValue toUDT(MessageAttachmentMetadata messageAttachment) {
        UDTValue result = (UDTValue)((UDTValue)this.typesProvider.getDefinedUserType("attachments").newValue().setString("id", messageAttachment.getAttachmentId().getId())).setBool("isInline", messageAttachment.isInline());
        messageAttachment.getName().ifPresent(name -> result.setString("name", name));
        messageAttachment.getCid().ifPresent(cid -> result.setString("cid", cid.getValue()));
        return result;
    }

    private UDTValue toUDT(MessageAttachmentRepresentation messageAttachment) {
        UDTValue result = (UDTValue)((UDTValue)this.typesProvider.getDefinedUserType("attachments").newValue().setString("id", messageAttachment.getAttachmentId().getId())).setBool("isInline", messageAttachment.isInline());
        messageAttachment.getName().ifPresent(name -> result.setString("name", name));
        messageAttachment.getCid().ifPresent(cid -> result.setString("cid", cid.getValue()));
        return result;
    }

    public Mono<MessageRepresentation> retrieveMessage(ComposedMessageIdWithMetaData id, MessageMapper.FetchType fetchType) {
        CassandraMessageId cassandraMessageId = (CassandraMessageId)id.getComposedMessageId().getMessageId();
        return this.retrieveMessage(cassandraMessageId, fetchType);
    }

    public Mono<MessageRepresentation> retrieveMessage(CassandraMessageId cassandraMessageId, MessageMapper.FetchType fetchType) {
        return this.retrieveRow(cassandraMessageId).flatMap(row -> this.message((Row)row, cassandraMessageId, fetchType));
    }

    private Mono<Row> retrieveRow(CassandraMessageId messageId) {
        return this.cassandraAsyncExecutor.executeSingleRow(this.select.bind().setUUID("messageId", messageId.get()).setConsistencyLevel(this.consistencyLevel));
    }

    private Mono<MessageRepresentation> message(Row row, CassandraMessageId cassandraMessageId, MessageMapper.FetchType fetchType) {
        BlobId headerId = this.retrieveBlobId("headerContent", row);
        BlobId bodyId = this.retrieveBlobId("bodyContent", row);
        int bodyStartOctet = row.getInt("bodyStartOctet");
        return this.buildContentRetriever(fetchType, headerId, bodyId, bodyStartOctet).map(content -> new MessageRepresentation(cassandraMessageId, row.getTimestamp(CassandraMessageV3Table.INTERNAL_DATE_LOWERCASE), row.getLong(CassandraMessageV3Table.FULL_CONTENT_OCTETS_LOWERCASE), row.getInt(CassandraMessageV3Table.BODY_START_OCTET_LOWERCASE), (Content)new ByteContent(content), this.getProperties(row), (List)this.getAttachments(row).collect(ImmutableList.toImmutableList()), headerId, bodyId));
    }

    private Properties getProperties(Row row) {
        PropertyBuilder property = new PropertyBuilder();
        property.setContentDescription(row.getString("contentDescription"));
        property.setContentDispositionType(row.getString("contentDispositionType"));
        property.setMediaType(row.getString("mediaType"));
        property.setSubType(row.getString("subType"));
        property.setContentID(row.getString("contentId"));
        property.setContentMD5(row.getString("contentMd5"));
        property.setContentTransferEncoding(row.getString("contentTransferEncoding"));
        property.setContentLocation(row.getString("contentLocation"));
        property.setContentLanguage((List)row.get("contentLanguage", LIST_OF_STRINGS_CODEC));
        property.setContentDispositionParameters((Map)row.get("contentDispositionParameters", MAP_OF_STRINGS_CODEC));
        property.setContentTypeParameters((Map)row.get("contentTypeParameters", MAP_OF_STRINGS_CODEC));
        property.setTextualLineCount(Long.valueOf(row.getLong(CassandraMessageV3Table.TEXTUAL_LINE_COUNT_LOWERCASE)));
        return property.build();
    }

    private Stream<MessageAttachmentRepresentation> getAttachments(Row row) {
        List udtValues = (List)row.get("attachments", LIST_OF_UDT);
        return this.attachmentByIds(udtValues);
    }

    private Stream<MessageAttachmentRepresentation> attachmentByIds(List<UDTValue> udtValues) {
        return udtValues.stream().map(this::messageAttachmentByIdFrom);
    }

    private MessageAttachmentRepresentation messageAttachmentByIdFrom(UDTValue udtValue) {
        return MessageAttachmentRepresentation.builder().attachmentId(AttachmentId.from((String)udtValue.getString("id"))).name(udtValue.getString("name")).cid(this.cidParser.parse(udtValue.getString("cid"))).isInline(udtValue.getBool("isInline")).build();
    }

    public Mono<Void> delete(CassandraMessageId messageId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.delete.bind().setUUID("messageId", messageId.get()));
    }

    private Mono<byte[]> buildContentRetriever(MessageMapper.FetchType fetchType, BlobId headerId, BlobId bodyId, int bodyStartOctet) {
        switch (fetchType) {
            case FULL: {
                return this.getFullContent(headerId, bodyId);
            }
            case HEADERS: {
                return this.getContent(headerId, BlobStore.StoragePolicy.SIZE_BASED);
            }
            case BODY: {
                return this.getContent(bodyId, BlobStore.StoragePolicy.LOW_COST).map(data -> Bytes.concat((byte[][])new byte[][]{new byte[bodyStartOctet], data}));
            }
            case METADATA: {
                return Mono.just((Object)EMPTY_BYTE_ARRAY);
            }
        }
        throw new RuntimeException("Unknown FetchType " + fetchType);
    }

    private Mono<byte[]> getFullContent(BlobId headerId, BlobId bodyId) {
        return this.getContent(headerId, BlobStore.StoragePolicy.SIZE_BASED).zipWith(this.getContent(bodyId, BlobStore.StoragePolicy.LOW_COST), (xva$0, xva$1) -> Bytes.concat((byte[][])new byte[][]{xva$0, xva$1}));
    }

    private Mono<byte[]> getContent(BlobId blobId, BlobStore.StoragePolicy storagePolicy) {
        return Mono.from((Publisher)this.blobStore.readBytes(this.blobStore.getDefaultBucketName(), blobId, storagePolicy));
    }

    private BlobId retrieveBlobId(String field, Row row) {
        return this.blobIdFactory.from(row.getString(field));
    }

    Flux<BlobId> listBlobs() {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.listBlobs.bind()).flatMapIterable(row -> ImmutableList.of((Object)this.blobIdFactory.from(row.getString(CassandraMessageV3Table.HEADER_CONTENT_LOWERCASE)), (Object)this.blobIdFactory.from(row.getString(CassandraMessageV3Table.BODY_CONTENT_LOWERCASE))));
    }
}

