/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.utils;

import com.google.common.base.Strings;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.function.Function;
import org.apache.james.util.DurationParser;
import org.apache.james.util.streams.Limit;
import org.apache.james.util.streams.Offset;
import org.apache.james.webadmin.utils.ErrorResponder;
import spark.Request;

public class ParametersExtractor {
    public static final String LIMIT_PARAMETER_NAME = "limit";
    public static final String OFFSET_PARAMETER_NAME = "offset";

    public static Limit extractLimit(Request request) {
        return Limit.from(ParametersExtractor.extractPositiveInteger(request, LIMIT_PARAMETER_NAME).map(value -> ParametersExtractor.assertNotZero(value, LIMIT_PARAMETER_NAME)));
    }

    public static Offset extractOffset(Request request) {
        return Offset.from(ParametersExtractor.extractPositiveInteger(request, OFFSET_PARAMETER_NAME));
    }

    public static Optional<Double> extractPositiveDouble(Request request, String parameterName) {
        return ParametersExtractor.extractPositiveNumber(request, parameterName, Double::valueOf);
    }

    public static Optional<Integer> extractPositiveInteger(Request request, String parameterName) {
        return ParametersExtractor.extractPositiveNumber(request, parameterName, Integer::valueOf);
    }

    public static Optional<Duration> extractDuration(Request request, String parameterName) {
        return Optional.ofNullable(request.queryParams(parameterName)).filter(s -> !s.isEmpty()).map(raw -> DurationParser.parse((String)raw, (ChronoUnit)ChronoUnit.SECONDS));
    }

    private static <T extends Number> Optional<T> extractPositiveNumber(Request request, String parameterName, Function<String, T> toNumber) {
        try {
            return Optional.ofNullable(request.queryParams(parameterName)).filter(s -> !Strings.isNullOrEmpty((String)s)).map(toNumber).map(value -> ParametersExtractor.assertPositive(value, parameterName));
        }
        catch (NumberFormatException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).cause(e).message("Can not parse %s", parameterName).haltError();
        }
    }

    private static <T extends Number> T assertPositive(T value, String parameterName) {
        if (value.doubleValue() < 0.0) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("%s can not be negative", parameterName).haltError();
        }
        return value;
    }

    private static int assertNotZero(int value, String parameterName) {
        if (value == 0) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("%s can not be equal to zero", parameterName).haltError();
        }
        return value;
    }
}

