/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.v7.search;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Optional;
import org.apache.james.backends.es.v7.AliasName;
import org.apache.james.backends.es.v7.ReactorElasticSearchClient;
import org.apache.james.backends.es.v7.ReadAliasName;
import org.apache.james.backends.es.v7.RoutingKey;
import org.apache.james.backends.es.v7.search.ScrolledSearch;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.elasticsearch.v7.query.QueryConverter;
import org.apache.james.mailbox.elasticsearch.v7.query.SortConverter;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.util.ReactorUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class ElasticSearchSearcher {
    public static final int DEFAULT_SEARCH_SIZE = 100;
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchSearcher.class);
    private static final TimeValue TIMEOUT = TimeValue.timeValueMinutes((long)1L);
    private static final ImmutableList<String> STORED_FIELDS = ImmutableList.of((Object)"mailboxId", (Object)"uid", (Object)"messageId");
    private static final int MAX_ROUTING_KEY = 5;
    private final ReactorElasticSearchClient client;
    private final QueryConverter queryConverter;
    private final int size;
    private final MailboxId.Factory mailboxIdFactory;
    private final MessageId.Factory messageIdFactory;
    private final AliasName aliasName;
    private final RoutingKey.Factory<MailboxId> routingKeyFactory;

    public ElasticSearchSearcher(ReactorElasticSearchClient client, QueryConverter queryConverter, int size, MailboxId.Factory mailboxIdFactory, MessageId.Factory messageIdFactory, ReadAliasName aliasName, RoutingKey.Factory<MailboxId> routingKeyFactory) {
        this.client = client;
        this.queryConverter = queryConverter;
        this.size = size;
        this.mailboxIdFactory = mailboxIdFactory;
        this.messageIdFactory = messageIdFactory;
        this.aliasName = aliasName;
        this.routingKeyFactory = routingKeyFactory;
    }

    public Flux<MessageSearchIndex.SearchResult> search(Collection<MailboxId> mailboxIds, SearchQuery query, Optional<Integer> limit) {
        SearchRequest searchRequest = this.prepareSearch(mailboxIds, query, limit);
        Flux pairStream = new ScrolledSearch(this.client, searchRequest).searchHits().map(this::extractContentFromHit).handle(ReactorUtils.publishIfPresent());
        return limit.map(arg_0 -> ((Flux)pairStream).take(arg_0)).orElse(pairStream);
    }

    private SearchRequest prepareSearch(Collection<MailboxId> mailboxIds, SearchQuery query, Optional<Integer> limit) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query(this.queryConverter.from(mailboxIds, query)).size(this.computeRequiredSize(limit)).storedFields(STORED_FIELDS);
        query.getSorts().stream().map(SortConverter::convertSort).forEach(arg_0 -> ((SearchSourceBuilder)searchSourceBuilder).sort(arg_0));
        SearchRequest request = new SearchRequest(new String[]{this.aliasName.getValue()}).scroll(TIMEOUT).source(searchSourceBuilder);
        return this.toRoutingKey(mailboxIds).map(arg_0 -> ((SearchRequest)request).routing(arg_0)).orElse(request);
    }

    private Optional<String[]> toRoutingKey(Collection<MailboxId> mailboxIds) {
        if (mailboxIds.size() < 5) {
            return Optional.of((String[])mailboxIds.stream().map(arg_0 -> this.routingKeyFactory.from(arg_0)).map(RoutingKey::asString).toArray(String[]::new));
        }
        return Optional.empty();
    }

    private int computeRequiredSize(Optional<Integer> limit) {
        return limit.map(value -> Math.min(value, this.size)).orElse(this.size);
    }

    private Optional<MessageSearchIndex.SearchResult> extractContentFromHit(SearchHit hit) {
        DocumentField mailboxId = hit.field("mailboxId");
        DocumentField uid = hit.field("uid");
        Optional<DocumentField> id = this.retrieveMessageIdField(hit);
        if (mailboxId != null && uid != null) {
            Number uidAsNumber = (Number)uid.getValue();
            return Optional.of(new MessageSearchIndex.SearchResult(id.map(field -> this.messageIdFactory.fromString((String)field.getValue())), this.mailboxIdFactory.fromString((String)mailboxId.getValue()), MessageUid.of((long)uidAsNumber.longValue())));
        }
        LOGGER.warn("Can not extract UID, MessageID and/or MailboxId for search result {}", (Object)hit.getId());
        return Optional.empty();
    }

    private Optional<DocumentField> retrieveMessageIdField(SearchHit hit) {
        if (hit.getFields().containsKey("messageId")) {
            return Optional.ofNullable(hit.field("messageId"));
        }
        return Optional.empty();
    }
}

