/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.quota;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.apache.james.core.Domain;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.UnsupportedOperationException;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.MaxQuotaManager;

public class FixedMaxQuotaManager
implements MaxQuotaManager {
    private Optional<QuotaSizeLimit> maxStorage = Optional.empty();
    private Optional<QuotaCountLimit> maxMessage = Optional.empty();

    public void setMaxStorage(QuotaRoot quotaRoot, QuotaSizeLimit maxStorageQuota) throws MailboxException {
        throw new UnsupportedOperationException("Can not modify QuotaRoot specific upper limit for FixedMaxQuotaManager");
    }

    public void setMaxMessage(QuotaRoot quotaRoot, QuotaCountLimit maxMessageCount) throws MailboxException {
        throw new UnsupportedOperationException("Can not modify QuotaRoot specific upper limit for FixedMaxQuotaManager");
    }

    public void removeMaxMessage(QuotaRoot quotaRoot) throws MailboxException {
        throw new UnsupportedOperationException("Can not modify QuotaRoot specific upper limit for FixedMaxQuotaManager");
    }

    public void removeMaxStorage(QuotaRoot quotaRoot) throws MailboxException {
        throw new UnsupportedOperationException("Can not modify QuotaRoot specific upper limit for FixedMaxQuotaManager");
    }

    public void setDomainMaxMessage(Domain domain, QuotaCountLimit count) throws MailboxException {
        throw new UnsupportedOperationException("Can not modify domain specific upper limit for FixedMaxQuotaManager");
    }

    public void setDomainMaxStorage(Domain domain, QuotaSizeLimit size) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Can not modify domain specific upper limit for FixedMaxQuotaManager");
    }

    public void setGlobalMaxStorage(QuotaSizeLimit globalMaxStorage) {
        this.maxStorage = Optional.of(globalMaxStorage);
    }

    public void removeGlobalMaxStorage() throws MailboxException {
        throw new UnsupportedOperationException("Can not modify QuotaRoot specific upper limit for FixedMaxQuotaManager");
    }

    public void removeGlobalMaxMessage() {
        this.maxMessage = Optional.empty();
    }

    public void setGlobalMaxMessage(QuotaCountLimit globalMaxMessageCount) {
        this.maxMessage = Optional.empty();
    }

    public Optional<QuotaSizeLimit> getMaxStorage(QuotaRoot quotaRoot) {
        return this.maxStorage;
    }

    public Optional<QuotaCountLimit> getMaxMessage(QuotaRoot quotaRoot) {
        return this.maxMessage;
    }

    public Map<Quota.Scope, QuotaCountLimit> listMaxMessagesDetails(QuotaRoot quotaRoot) {
        return (Map)this.maxMessage.map(value -> ImmutableMap.of((Object)Quota.Scope.Global, (Object)value)).orElse(ImmutableMap.of());
    }

    public Map<Quota.Scope, QuotaSizeLimit> listMaxStorageDetails(QuotaRoot quotaRoot) {
        return (Map)this.maxStorage.map(value -> ImmutableMap.of((Object)Quota.Scope.Global, (Object)value)).orElse(ImmutableMap.of());
    }

    public Optional<QuotaCountLimit> getDomainMaxMessage(Domain domain) {
        return Optional.empty();
    }

    public Optional<QuotaSizeLimit> getDomainMaxStorage(Domain domain) {
        return Optional.empty();
    }

    public void removeDomainMaxMessage(Domain domain) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Can not modify domain specific upper limit for FixedMaxQuotaManager");
    }

    public void removeDomainMaxStorage(Domain domain) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Can not modify domain specific upper limit for FixedMaxQuotaManager");
    }

    public Optional<QuotaSizeLimit> getGlobalMaxStorage() {
        return this.maxStorage;
    }

    public Optional<QuotaCountLimit> getGlobalMaxMessage() {
        return this.maxMessage;
    }
}

