/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.cassandra.cache;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.cassandra.cache.BlobStoreCache;
import org.apache.james.blob.cassandra.cache.CassandraCacheConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class CassandraBlobStoreCache
implements BlobStoreCache {
    public static final Logger LOGGER = LoggerFactory.getLogger(CassandraBlobStoreCache.class);
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement insertStatement;
    private final PreparedStatement selectStatement;
    private final PreparedStatement deleteStatement;
    private final int readTimeOutFromDataBase;
    private final int timeToLive;

    @Inject
    @VisibleForTesting
    CassandraBlobStoreCache(@Named(value="cache") Session session, CassandraCacheConfiguration cacheConfiguration) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.insertStatement = this.prepareInsert(session);
        this.selectStatement = this.prepareSelect(session);
        this.deleteStatement = this.prepareDelete(session);
        this.readTimeOutFromDataBase = Math.toIntExact(cacheConfiguration.getReadTimeOut().toMillis());
        this.timeToLive = Math.toIntExact(cacheConfiguration.getTtl().getSeconds());
    }

    public Mono<Void> cache(BlobId blobId, byte[] bytes) {
        return this.save(blobId, this.toByteBuffer(bytes));
    }

    public Mono<byte[]> read(BlobId blobId) {
        return this.cassandraAsyncExecutor.executeSingleRow(this.selectStatement.bind().setString("id", blobId.asString()).setConsistencyLevel(ConsistencyLevel.ONE).setReadTimeoutMillis(this.readTimeOutFromDataBase)).map(this::toByteArray).onErrorResume(e -> {
            LOGGER.warn("Fail reading blob store cache", e);
            return Mono.empty();
        });
    }

    public Mono<Void> remove(BlobId blobId) {
        return this.cassandraAsyncExecutor.executeVoid(this.deleteStatement.bind().setString("id", blobId.asString()).setConsistencyLevel(ConsistencyLevel.ALL));
    }

    private Mono<Void> save(BlobId blobId, ByteBuffer data) {
        return this.cassandraAsyncExecutor.executeVoid(this.insertStatement.bind().setString("id", blobId.asString()).setBytes("data", data).setInt("ttl", this.timeToLive).setConsistencyLevel(ConsistencyLevel.ONE)).onErrorResume(e -> {
            LOGGER.warn("Failed saving {} in blob store cache", (Object)blobId, e);
            return Mono.empty();
        });
    }

    private ByteBuffer toByteBuffer(byte[] bytes) {
        return ByteBuffer.wrap(bytes, 0, bytes.length);
    }

    private byte[] toByteArray(Row row) {
        ByteBuffer byteBuffer = row.getBytes("data");
        byte[] data = new byte[byteBuffer.remaining()];
        byteBuffer.get(data);
        return data;
    }

    private PreparedStatement prepareDelete(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("blob_cache").where(QueryBuilder.eq((String)"id", (Object)QueryBuilder.bindMarker((String)"id"))));
    }

    private PreparedStatement prepareSelect(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select().from("blob_cache").where(QueryBuilder.eq((String)"id", (Object)QueryBuilder.bindMarker((String)"id"))));
    }

    private PreparedStatement prepareInsert(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"blob_cache").value("id", (Object)QueryBuilder.bindMarker((String)"id")).value("data", (Object)QueryBuilder.bindMarker((String)"data")).using(QueryBuilder.ttl((BindMarker)QueryBuilder.bindMarker((String)"ttl"))));
    }
}

