/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.quota;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.mailbox.cassandra.quota.Limits;
import org.apache.james.mailbox.cassandra.quota.QuotaCodec;
import org.apache.james.util.ReactorUtils;
import reactor.core.publisher.Mono;

public class CassandraGlobalMaxQuotaDao {
    private final CassandraAsyncExecutor queryExecutor;
    private final PreparedStatement setGlobalMaxStorageStatement;
    private final PreparedStatement setGlobalMaxMessageStatement;
    private final PreparedStatement getGlobalMaxStatement;
    private final PreparedStatement removeMessageMaxQuotaStatement;
    private final PreparedStatement removeStorageMaxQuotaStatement;

    @Inject
    public CassandraGlobalMaxQuotaDao(Session session) {
        this.queryExecutor = new CassandraAsyncExecutor(session);
        this.getGlobalMaxStatement = session.prepare((RegularStatement)this.getGlobalMaxStatement());
        this.setGlobalMaxMessageStatement = session.prepare((RegularStatement)this.setGlobalMaxMessageStatement());
        this.setGlobalMaxStorageStatement = session.prepare((RegularStatement)this.setGlobalMaxStorageStatement());
        this.removeMessageMaxQuotaStatement = session.prepare((RegularStatement)this.removeMessageMaxQuotaStatement());
        this.removeStorageMaxQuotaStatement = session.prepare((RegularStatement)this.removeStorageMaxQuotaStatement());
    }

    private Delete.Where removeMessageMaxQuotaStatement() {
        return QueryBuilder.delete((String[])new String[]{"message"}).from("defaultMaxQuota2").where(QueryBuilder.eq((String)"key", (Object)QueryBuilder.bindMarker((String)"key")));
    }

    private Delete.Where removeStorageMaxQuotaStatement() {
        return QueryBuilder.delete((String[])new String[]{"storage"}).from("defaultMaxQuota2").where(QueryBuilder.eq((String)"key", (Object)QueryBuilder.bindMarker((String)"key")));
    }

    private Insert setGlobalMaxStorageStatement() {
        return QueryBuilder.insertInto((String)"defaultMaxQuota2").value("key", (Object)"value").value("storage", (Object)QueryBuilder.bindMarker((String)"storage"));
    }

    private Insert setGlobalMaxMessageStatement() {
        return QueryBuilder.insertInto((String)"defaultMaxQuota2").value("key", (Object)"value").value("message", (Object)QueryBuilder.bindMarker((String)"message"));
    }

    private Select.Where getGlobalMaxStatement() {
        return QueryBuilder.select().from("defaultMaxQuota2").where(QueryBuilder.eq((String)"key", (Object)QueryBuilder.bindMarker((String)"key")));
    }

    Mono<Void> setGlobalMaxStorage(QuotaSizeLimit globalMaxStorage) {
        return this.queryExecutor.executeVoid((Statement)this.setGlobalMaxStorageStatement.bind(new Object[]{QuotaCodec.quotaValueToLong(globalMaxStorage)}));
    }

    Mono<Void> setGlobalMaxMessage(QuotaCountLimit globalMaxMessageCount) {
        return this.queryExecutor.executeVoid((Statement)this.setGlobalMaxMessageStatement.bind(new Object[]{QuotaCodec.quotaValueToLong(globalMaxMessageCount)}));
    }

    Mono<QuotaSizeLimit> getGlobalMaxStorage() {
        return this.queryExecutor.executeSingleRow((Statement)this.getGlobalMaxStatement.bind().setString("key", "value")).map(row -> Optional.ofNullable((Long)row.get("storage", Long.class))).handle(ReactorUtils.publishIfPresent()).map(QuotaCodec::longToQuotaSize).handle(ReactorUtils.publishIfPresent());
    }

    Mono<QuotaCountLimit> getGlobalMaxMessage() {
        return this.queryExecutor.executeSingleRow((Statement)this.getGlobalMaxStatement.bind().setString("key", "value")).map(row -> Optional.ofNullable((Long)row.get("message", Long.class))).handle(ReactorUtils.publishIfPresent()).map(QuotaCodec::longToQuotaCount).handle(ReactorUtils.publishIfPresent());
    }

    Mono<Void> removeGlobaltMaxStorage() {
        return this.queryExecutor.executeVoid((Statement)this.removeStorageMaxQuotaStatement.bind().setString("key", "value"));
    }

    Mono<Void> removeGlobalMaxMessage() {
        return this.queryExecutor.executeVoid((Statement)this.removeMessageMaxQuotaStatement.bind().setString("key", "value"));
    }

    Mono<Limits> getGlobalLimits() {
        return this.queryExecutor.executeSingleRow((Statement)this.getGlobalMaxStatement.bind().setString("key", "value")).map(row -> new Limits(Optional.ofNullable((Long)row.get("storage", Long.class)).flatMap(QuotaCodec::longToQuotaSize), Optional.ofNullable((Long)row.get("message", Long.class)).flatMap(QuotaCodec::longToQuotaCount))).switchIfEmpty(Mono.just((Object)Limits.empty()));
    }
}

