/****************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 ****************************************************************/



package org.apache.james.transport.mailets;

import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Simplest Mailet which destroys any incoming messages
 * by setting their state to GHOST
 */
public class Null extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(Null.class);

    @Override
    public void service(Mail mail) {
        LOGGER.debug("Null mailet is destroying mail {} from {} for {}", mail.getName(), mail.getMaybeSender(),
                mail.getRecipients());
        mail.setState(Mail.GHOST);
    }

    @Override
    public String getMailetInfo() {
        return "Null Mailet";
    }
}

