/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.database;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class SetSchemaReplicationFactorPlan
extends ConfigPhysicalPlan {
    private String database;
    private int schemaReplicationFactor;

    public SetSchemaReplicationFactorPlan() {
        super(ConfigPhysicalPlanType.SetSchemaReplicationFactor);
    }

    public SetSchemaReplicationFactorPlan(String database, int schemaReplicationFactor) {
        this();
        this.database = database;
        this.schemaReplicationFactor = schemaReplicationFactor;
    }

    public String getDatabase() {
        return this.database;
    }

    public int getSchemaReplicationFactor() {
        return this.schemaReplicationFactor;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        BasicStructureSerDeUtil.write((String)this.database, (DataOutputStream)stream);
        stream.writeInt(this.schemaReplicationFactor);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.database = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        this.schemaReplicationFactor = buffer.getInt();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetSchemaReplicationFactorPlan that = (SetSchemaReplicationFactorPlan)o;
        return this.schemaReplicationFactor == that.schemaReplicationFactor && this.database.equals(that.database);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.database, this.schemaReplicationFactor);
    }
}

