/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.execution.querystats;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.queryengine.plan.relational.execution.querystats.QueryPlanOptimizerStatistics;

public class QueryPlanOptimizerStats {
    private final String rule;
    private final AtomicLong invocations = new AtomicLong();
    private final AtomicLong applied = new AtomicLong();
    private final AtomicLong totalTime = new AtomicLong();
    private final AtomicLong failures = new AtomicLong();

    public QueryPlanOptimizerStats(String rule) {
        this.rule = Objects.requireNonNull(rule, "rule is null");
    }

    public void record(long nanos, boolean applied) {
        if (applied) {
            this.applied.incrementAndGet();
        }
        this.invocations.incrementAndGet();
        this.totalTime.addAndGet(nanos);
    }

    public void recordFailure() {
        this.failures.incrementAndGet();
    }

    public String getRule() {
        return this.rule;
    }

    public long getInvocations() {
        return this.invocations.get();
    }

    public long getApplied() {
        return this.applied.get();
    }

    public long getFailures() {
        return this.failures.get();
    }

    public long getTotalTime() {
        return this.totalTime.get();
    }

    public QueryPlanOptimizerStatistics snapshot() {
        return new QueryPlanOptimizerStatistics(this.rule, this.invocations.get(), this.applied.get(), this.totalTime.get(), this.failures.get());
    }

    public QueryPlanOptimizerStats merge(QueryPlanOptimizerStats other) {
        Preconditions.checkArgument((boolean)this.rule.equals(other.getRule()), (String)"Cannot merge stats for different rules: %s and %s", (Object)this.rule, (Object)other.getRule());
        this.invocations.addAndGet(other.getInvocations());
        this.applied.addAndGet(other.getApplied());
        this.failures.addAndGet(other.getFailures());
        this.totalTime.addAndGet(other.getTotalTime());
        return this;
    }
}

