/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.receiver.visitor;

import java.io.File;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBTreePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TreePattern;
import org.apache.iotdb.db.pipe.event.common.tsfile.parser.scan.TsFileInsertionEventScanParser;
import org.apache.iotdb.db.pipe.receiver.protocol.thrift.IoTDBDataNodeReceiver;
import org.apache.iotdb.db.pipe.receiver.transform.statement.PipeConvertedInsertRowStatement;
import org.apache.iotdb.db.pipe.receiver.transform.statement.PipeConvertedInsertTabletStatement;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferTabletRawReq;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementNode;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsOfOneDeviceStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTreeStatementDataTypeConvertExecutionVisitor
extends StatementVisitor<Optional<TSStatus>, TSStatus> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTreeStatementDataTypeConvertExecutionVisitor.class);
    private final StatementExecutor statementExecutor;

    public PipeTreeStatementDataTypeConvertExecutionVisitor(StatementExecutor statementExecutor) {
        this.statementExecutor = statementExecutor;
    }

    private Optional<TSStatus> tryExecute(Statement statement) {
        try {
            return Optional.of(this.statementExecutor.execute(statement));
        }
        catch (Exception e) {
            LOGGER.warn("Failed to execute statement after data type conversion.", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public Optional<TSStatus> visitNode(StatementNode statementNode, TSStatus status) {
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<TSStatus> visitLoadFile(LoadTsFileStatement loadTsFileStatement, TSStatus status) {
        if (status.getCode() != TSStatusCode.LOAD_FILE_ERROR.getStatusCode()) return Optional.empty();
        if (status.getMessage() != null) {
            if (status.getMessage().contains("memory")) return Optional.empty();
        }
        if (!PipeConfig.getInstance().isPipeReceiverLoadConversionEnabled()) {
            return Optional.empty();
        }
        LOGGER.warn("Data type mismatch detected (TSStatus: {}) for LoadTsFileStatement: {}. Start data type conversion.", (Object)status, (Object)loadTsFileStatement);
        for (File file : loadTsFileStatement.getTsFiles()) {
            try (TsFileInsertionEventScanParser parser = new TsFileInsertionEventScanParser(file, (TreePattern)new IoTDBTreePattern(null), Long.MIN_VALUE, Long.MAX_VALUE, null, null);){
                for (Pair<Tablet, Boolean> tabletWithIsAligned : parser.toTabletWithIsAligneds()) {
                    TSStatus result;
                    PipeConvertedInsertTabletStatement statement = new PipeConvertedInsertTabletStatement(PipeTransferTabletRawReq.toTPipeTransferRawReq((Tablet)tabletWithIsAligned.getLeft(), (Boolean)tabletWithIsAligned.getRight()).constructStatement(), false);
                    try {
                        result = statement.accept(IoTDBDataNodeReceiver.STATEMENT_STATUS_VISITOR, this.statementExecutor.execute(statement));
                        for (int i = 0; i < 5 && result.getCode() == TSStatusCode.PIPE_RECEIVER_TEMPORARY_UNAVAILABLE_EXCEPTION.getStatusCode(); ++i) {
                            Thread.sleep(100L * (long)(i + 1));
                            result = statement.accept(IoTDBDataNodeReceiver.STATEMENT_STATUS_VISITOR, this.statementExecutor.execute(statement));
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof InterruptedException) {
                            Thread.currentThread().interrupt();
                        }
                        result = statement.accept(IoTDBDataNodeReceiver.STATEMENT_EXCEPTION_VISITOR, e);
                    }
                    if (result.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || result.getCode() == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode() || result.getCode() == TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()) continue;
                    Optional<TSStatus> optional = Optional.empty();
                    return optional;
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to convert data type for LoadTsFileStatement: {}.", (Object)loadTsFileStatement, (Object)e);
                return Optional.empty();
            }
        }
        if (loadTsFileStatement.isDeleteAfterLoad()) {
            loadTsFileStatement.getTsFiles().forEach(FileUtils::deleteQuietly);
        }
        LOGGER.warn("Data type conversion for LoadTsFileStatement {} is successful.", (Object)loadTsFileStatement);
        return Optional.of(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
    }

    @Override
    public Optional<TSStatus> visitInsertRow(InsertRowStatement insertRowStatement, TSStatus status) {
        return this.tryExecute(new PipeConvertedInsertRowStatement(insertRowStatement));
    }

    @Override
    public Optional<TSStatus> visitInsertRows(InsertRowsStatement insertRowsStatement, TSStatus status) {
        if (insertRowsStatement.getInsertRowStatementList() == null || insertRowsStatement.getInsertRowStatementList().isEmpty()) {
            return Optional.empty();
        }
        InsertRowsStatement convertedInsertRowsStatement = new InsertRowsStatement();
        convertedInsertRowsStatement.setInsertRowStatementList(insertRowsStatement.getInsertRowStatementList().stream().map(PipeConvertedInsertRowStatement::new).collect(Collectors.toList()));
        return this.tryExecute(convertedInsertRowsStatement);
    }

    @Override
    public Optional<TSStatus> visitInsertRowsOfOneDevice(InsertRowsOfOneDeviceStatement insertRowsOfOneDeviceStatement, TSStatus status) {
        if (insertRowsOfOneDeviceStatement.getInsertRowStatementList() == null || insertRowsOfOneDeviceStatement.getInsertRowStatementList().isEmpty()) {
            return Optional.empty();
        }
        InsertRowsOfOneDeviceStatement convertedInsertRowsOfOneDeviceStatement = new InsertRowsOfOneDeviceStatement();
        convertedInsertRowsOfOneDeviceStatement.setInsertRowStatementList(insertRowsOfOneDeviceStatement.getInsertRowStatementList().stream().map(PipeConvertedInsertRowStatement::new).collect(Collectors.toList()));
        return this.tryExecute(convertedInsertRowsOfOneDeviceStatement);
    }

    @Override
    public Optional<TSStatus> visitInsertTablet(InsertTabletStatement insertTabletStatement, TSStatus status) {
        return this.tryExecute(new PipeConvertedInsertTabletStatement(insertTabletStatement));
    }

    @Override
    public Optional<TSStatus> visitInsertMultiTablets(InsertMultiTabletsStatement insertMultiTabletsStatement, TSStatus status) {
        if (insertMultiTabletsStatement.getInsertTabletStatementList() == null || insertMultiTabletsStatement.getInsertTabletStatementList().isEmpty()) {
            return Optional.empty();
        }
        InsertMultiTabletsStatement convertedInsertMultiTabletsStatement = new InsertMultiTabletsStatement();
        convertedInsertMultiTabletsStatement.setInsertTabletStatementList(insertMultiTabletsStatement.getInsertTabletStatementList().stream().map(PipeConvertedInsertTabletStatement::new).collect(Collectors.toList()));
        return this.tryExecute(convertedInsertMultiTabletsStatement);
    }

    @FunctionalInterface
    public static interface StatementExecutor {
        public TSStatus execute(Statement var1);
    }
}

