/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.write.record.datapoint;

import java.io.IOException;
import java.time.LocalDate;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.DateUtils;
import org.apache.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.tsfile.write.record.datapoint.DataPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateDataPoint
extends DataPoint {
    private static final Logger LOG = LoggerFactory.getLogger(DateDataPoint.class);
    private LocalDate value;

    public DateDataPoint(String measurementId, LocalDate v) {
        super(TSDataType.DATE, measurementId);
        this.value = v;
    }

    @Override
    public void writeTo(long time, ChunkWriterImpl writer) throws IOException {
        if (writer == null) {
            LOG.warn("given IChunkWriter is null, do nothing and return");
            return;
        }
        writer.write(time, DateUtils.parseDateExpressionToInt(this.value));
    }

    @Override
    public Object getValue() {
        return this.value == null ? null : DateUtils.parseDateExpressionToInt(this.value);
    }

    @Override
    public void setDate(LocalDate value) {
        this.value = value;
    }
}

