/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.NotificationMessage;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class PublishResponse
extends Structure
implements UaResponseMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=827");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=829");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=828");
    private final ResponseHeader responseHeader;
    private final UInteger subscriptionId;
    private final UInteger[] availableSequenceNumbers;
    private final Boolean moreNotifications;
    private final NotificationMessage notificationMessage;
    private final StatusCode[] results;
    private final DiagnosticInfo[] diagnosticInfos;

    public PublishResponse(ResponseHeader responseHeader, UInteger subscriptionId, UInteger[] availableSequenceNumbers, Boolean moreNotifications, NotificationMessage notificationMessage, StatusCode[] results, DiagnosticInfo[] diagnosticInfos) {
        this.responseHeader = responseHeader;
        this.subscriptionId = subscriptionId;
        this.availableSequenceNumbers = availableSequenceNumbers;
        this.moreNotifications = moreNotifications;
        this.notificationMessage = notificationMessage;
        this.results = results;
        this.diagnosticInfos = diagnosticInfos;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public UInteger getSubscriptionId() {
        return this.subscriptionId;
    }

    public UInteger[] getAvailableSequenceNumbers() {
        return this.availableSequenceNumbers;
    }

    public Boolean getMoreNotifications() {
        return this.moreNotifications;
    }

    public NotificationMessage getNotificationMessage() {
        return this.notificationMessage;
    }

    public StatusCode[] getResults() {
        return this.results;
    }

    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    protected PublishResponse(PublishResponseBuilder<?, ?> b) {
        super(b);
        this.responseHeader = ((PublishResponseBuilder)b).responseHeader;
        this.subscriptionId = ((PublishResponseBuilder)b).subscriptionId;
        this.availableSequenceNumbers = ((PublishResponseBuilder)b).availableSequenceNumbers;
        this.moreNotifications = ((PublishResponseBuilder)b).moreNotifications;
        this.notificationMessage = ((PublishResponseBuilder)b).notificationMessage;
        this.results = ((PublishResponseBuilder)b).results;
        this.diagnosticInfos = ((PublishResponseBuilder)b).diagnosticInfos;
    }

    public static PublishResponseBuilder<?, ?> builder() {
        return new PublishResponseBuilderImpl();
    }

    public PublishResponseBuilder<?, ?> toBuilder() {
        return new PublishResponseBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PublishResponse)) {
            return false;
        }
        PublishResponse other = (PublishResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$moreNotifications = this.getMoreNotifications();
        Boolean other$moreNotifications = other.getMoreNotifications();
        if (this$moreNotifications == null ? other$moreNotifications != null : !((Object)this$moreNotifications).equals(other$moreNotifications)) {
            return false;
        }
        ResponseHeader this$responseHeader = this.getResponseHeader();
        ResponseHeader other$responseHeader = other.getResponseHeader();
        if (this$responseHeader == null ? other$responseHeader != null : !((Object)this$responseHeader).equals(other$responseHeader)) {
            return false;
        }
        UInteger this$subscriptionId = this.getSubscriptionId();
        UInteger other$subscriptionId = other.getSubscriptionId();
        if (this$subscriptionId == null ? other$subscriptionId != null : !((Object)this$subscriptionId).equals(other$subscriptionId)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAvailableSequenceNumbers(), other.getAvailableSequenceNumbers())) {
            return false;
        }
        NotificationMessage this$notificationMessage = this.getNotificationMessage();
        NotificationMessage other$notificationMessage = other.getNotificationMessage();
        if (this$notificationMessage == null ? other$notificationMessage != null : !((Object)this$notificationMessage).equals(other$notificationMessage)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getResults(), other.getResults())) {
            return false;
        }
        return Arrays.deepEquals(this.getDiagnosticInfos(), other.getDiagnosticInfos());
    }

    protected boolean canEqual(Object other) {
        return other instanceof PublishResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $moreNotifications = this.getMoreNotifications();
        result = result * 59 + ($moreNotifications == null ? 43 : ((Object)$moreNotifications).hashCode());
        ResponseHeader $responseHeader = this.getResponseHeader();
        result = result * 59 + ($responseHeader == null ? 43 : ((Object)$responseHeader).hashCode());
        UInteger $subscriptionId = this.getSubscriptionId();
        result = result * 59 + ($subscriptionId == null ? 43 : ((Object)$subscriptionId).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getAvailableSequenceNumbers());
        NotificationMessage $notificationMessage = this.getNotificationMessage();
        result = result * 59 + ($notificationMessage == null ? 43 : ((Object)$notificationMessage).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getResults());
        result = result * 59 + Arrays.deepHashCode(this.getDiagnosticInfos());
        return result;
    }

    @Override
    public String toString() {
        return "PublishResponse(responseHeader=" + this.getResponseHeader() + ", subscriptionId=" + this.getSubscriptionId() + ", availableSequenceNumbers=" + Arrays.deepToString(this.getAvailableSequenceNumbers()) + ", moreNotifications=" + this.getMoreNotifications() + ", notificationMessage=" + this.getNotificationMessage() + ", results=" + Arrays.deepToString(this.getResults()) + ", diagnosticInfos=" + Arrays.deepToString(this.getDiagnosticInfos()) + ")";
    }

    private static final class PublishResponseBuilderImpl
    extends PublishResponseBuilder<PublishResponse, PublishResponseBuilderImpl> {
        private PublishResponseBuilderImpl() {
        }

        @Override
        protected PublishResponseBuilderImpl self() {
            return this;
        }

        @Override
        public PublishResponse build() {
            return new PublishResponse(this);
        }
    }

    public static abstract class PublishResponseBuilder<C extends PublishResponse, B extends PublishResponseBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ResponseHeader responseHeader;
        private UInteger subscriptionId;
        private UInteger[] availableSequenceNumbers;
        private Boolean moreNotifications;
        private NotificationMessage notificationMessage;
        private StatusCode[] results;
        private DiagnosticInfo[] diagnosticInfos;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PublishResponseBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(PublishResponse instance, PublishResponseBuilder<?, ?> b) {
            b.responseHeader(instance.responseHeader);
            b.subscriptionId(instance.subscriptionId);
            b.availableSequenceNumbers(instance.availableSequenceNumbers);
            b.moreNotifications(instance.moreNotifications);
            b.notificationMessage(instance.notificationMessage);
            b.results(instance.results);
            b.diagnosticInfos(instance.diagnosticInfos);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B responseHeader(ResponseHeader responseHeader) {
            this.responseHeader = responseHeader;
            return (B)this.self();
        }

        public B subscriptionId(UInteger subscriptionId) {
            this.subscriptionId = subscriptionId;
            return (B)this.self();
        }

        public B availableSequenceNumbers(UInteger[] availableSequenceNumbers) {
            this.availableSequenceNumbers = availableSequenceNumbers;
            return (B)this.self();
        }

        public B moreNotifications(Boolean moreNotifications) {
            this.moreNotifications = moreNotifications;
            return (B)this.self();
        }

        public B notificationMessage(NotificationMessage notificationMessage) {
            this.notificationMessage = notificationMessage;
            return (B)this.self();
        }

        public B results(StatusCode[] results) {
            this.results = results;
            return (B)this.self();
        }

        public B diagnosticInfos(DiagnosticInfo[] diagnosticInfos) {
            this.diagnosticInfos = diagnosticInfos;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "PublishResponse.PublishResponseBuilder(super=" + super.toString() + ", responseHeader=" + this.responseHeader + ", subscriptionId=" + this.subscriptionId + ", availableSequenceNumbers=" + Arrays.deepToString(this.availableSequenceNumbers) + ", moreNotifications=" + this.moreNotifications + ", notificationMessage=" + this.notificationMessage + ", results=" + Arrays.deepToString(this.results) + ", diagnosticInfos=" + Arrays.deepToString(this.diagnosticInfos) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<PublishResponse> {
        @Override
        public Class<PublishResponse> getType() {
            return PublishResponse.class;
        }

        @Override
        public PublishResponse decode(SerializationContext context, UaDecoder decoder) {
            ResponseHeader responseHeader = (ResponseHeader)decoder.readStruct("ResponseHeader", ResponseHeader.TYPE_ID);
            UInteger subscriptionId = decoder.readUInt32("SubscriptionId");
            UInteger[] availableSequenceNumbers = decoder.readUInt32Array("AvailableSequenceNumbers");
            Boolean moreNotifications = decoder.readBoolean("MoreNotifications");
            NotificationMessage notificationMessage = (NotificationMessage)decoder.readStruct("NotificationMessage", NotificationMessage.TYPE_ID);
            StatusCode[] results = decoder.readStatusCodeArray("Results");
            DiagnosticInfo[] diagnosticInfos = decoder.readDiagnosticInfoArray("DiagnosticInfos");
            return new PublishResponse(responseHeader, subscriptionId, availableSequenceNumbers, moreNotifications, notificationMessage, results, diagnosticInfos);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, PublishResponse value) {
            encoder.writeStruct("ResponseHeader", (Object)value.getResponseHeader(), ResponseHeader.TYPE_ID);
            encoder.writeUInt32("SubscriptionId", value.getSubscriptionId());
            encoder.writeUInt32Array("AvailableSequenceNumbers", value.getAvailableSequenceNumbers());
            encoder.writeBoolean("MoreNotifications", value.getMoreNotifications());
            encoder.writeStruct("NotificationMessage", (Object)value.getNotificationMessage(), NotificationMessage.TYPE_ID);
            encoder.writeStatusCodeArray("Results", value.getResults());
            encoder.writeDiagnosticInfoArray("DiagnosticInfos", value.getDiagnosticInfos());
        }
    }
}

