/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class RequestHeader
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=389");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=391");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=390");
    private final NodeId authenticationToken;
    private final DateTime timestamp;
    private final UInteger requestHandle;
    private final UInteger returnDiagnostics;
    private final String auditEntryId;
    private final UInteger timeoutHint;
    private final ExtensionObject additionalHeader;

    public RequestHeader(NodeId authenticationToken, DateTime timestamp, UInteger requestHandle, UInteger returnDiagnostics, String auditEntryId, UInteger timeoutHint, ExtensionObject additionalHeader) {
        this.authenticationToken = authenticationToken;
        this.timestamp = timestamp;
        this.requestHandle = requestHandle;
        this.returnDiagnostics = returnDiagnostics;
        this.auditEntryId = auditEntryId;
        this.timeoutHint = timeoutHint;
        this.additionalHeader = additionalHeader;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public NodeId getAuthenticationToken() {
        return this.authenticationToken;
    }

    public DateTime getTimestamp() {
        return this.timestamp;
    }

    public UInteger getRequestHandle() {
        return this.requestHandle;
    }

    public UInteger getReturnDiagnostics() {
        return this.returnDiagnostics;
    }

    public String getAuditEntryId() {
        return this.auditEntryId;
    }

    public UInteger getTimeoutHint() {
        return this.timeoutHint;
    }

    public ExtensionObject getAdditionalHeader() {
        return this.additionalHeader;
    }

    protected RequestHeader(RequestHeaderBuilder<?, ?> b) {
        super(b);
        this.authenticationToken = ((RequestHeaderBuilder)b).authenticationToken;
        this.timestamp = ((RequestHeaderBuilder)b).timestamp;
        this.requestHandle = ((RequestHeaderBuilder)b).requestHandle;
        this.returnDiagnostics = ((RequestHeaderBuilder)b).returnDiagnostics;
        this.auditEntryId = ((RequestHeaderBuilder)b).auditEntryId;
        this.timeoutHint = ((RequestHeaderBuilder)b).timeoutHint;
        this.additionalHeader = ((RequestHeaderBuilder)b).additionalHeader;
    }

    public static RequestHeaderBuilder<?, ?> builder() {
        return new RequestHeaderBuilderImpl();
    }

    public RequestHeaderBuilder<?, ?> toBuilder() {
        return new RequestHeaderBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestHeader)) {
            return false;
        }
        RequestHeader other = (RequestHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NodeId this$authenticationToken = this.getAuthenticationToken();
        NodeId other$authenticationToken = other.getAuthenticationToken();
        if (this$authenticationToken == null ? other$authenticationToken != null : !((Object)this$authenticationToken).equals(other$authenticationToken)) {
            return false;
        }
        DateTime this$timestamp = this.getTimestamp();
        DateTime other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        UInteger this$requestHandle = this.getRequestHandle();
        UInteger other$requestHandle = other.getRequestHandle();
        if (this$requestHandle == null ? other$requestHandle != null : !((Object)this$requestHandle).equals(other$requestHandle)) {
            return false;
        }
        UInteger this$returnDiagnostics = this.getReturnDiagnostics();
        UInteger other$returnDiagnostics = other.getReturnDiagnostics();
        if (this$returnDiagnostics == null ? other$returnDiagnostics != null : !((Object)this$returnDiagnostics).equals(other$returnDiagnostics)) {
            return false;
        }
        String this$auditEntryId = this.getAuditEntryId();
        String other$auditEntryId = other.getAuditEntryId();
        if (this$auditEntryId == null ? other$auditEntryId != null : !this$auditEntryId.equals(other$auditEntryId)) {
            return false;
        }
        UInteger this$timeoutHint = this.getTimeoutHint();
        UInteger other$timeoutHint = other.getTimeoutHint();
        if (this$timeoutHint == null ? other$timeoutHint != null : !((Object)this$timeoutHint).equals(other$timeoutHint)) {
            return false;
        }
        ExtensionObject this$additionalHeader = this.getAdditionalHeader();
        ExtensionObject other$additionalHeader = other.getAdditionalHeader();
        return !(this$additionalHeader == null ? other$additionalHeader != null : !((Object)this$additionalHeader).equals(other$additionalHeader));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestHeader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NodeId $authenticationToken = this.getAuthenticationToken();
        result = result * 59 + ($authenticationToken == null ? 43 : ((Object)$authenticationToken).hashCode());
        DateTime $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        UInteger $requestHandle = this.getRequestHandle();
        result = result * 59 + ($requestHandle == null ? 43 : ((Object)$requestHandle).hashCode());
        UInteger $returnDiagnostics = this.getReturnDiagnostics();
        result = result * 59 + ($returnDiagnostics == null ? 43 : ((Object)$returnDiagnostics).hashCode());
        String $auditEntryId = this.getAuditEntryId();
        result = result * 59 + ($auditEntryId == null ? 43 : $auditEntryId.hashCode());
        UInteger $timeoutHint = this.getTimeoutHint();
        result = result * 59 + ($timeoutHint == null ? 43 : ((Object)$timeoutHint).hashCode());
        ExtensionObject $additionalHeader = this.getAdditionalHeader();
        result = result * 59 + ($additionalHeader == null ? 43 : ((Object)$additionalHeader).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "RequestHeader(authenticationToken=" + this.getAuthenticationToken() + ", timestamp=" + this.getTimestamp() + ", requestHandle=" + this.getRequestHandle() + ", returnDiagnostics=" + this.getReturnDiagnostics() + ", auditEntryId=" + this.getAuditEntryId() + ", timeoutHint=" + this.getTimeoutHint() + ", additionalHeader=" + this.getAdditionalHeader() + ")";
    }

    private static final class RequestHeaderBuilderImpl
    extends RequestHeaderBuilder<RequestHeader, RequestHeaderBuilderImpl> {
        private RequestHeaderBuilderImpl() {
        }

        @Override
        protected RequestHeaderBuilderImpl self() {
            return this;
        }

        @Override
        public RequestHeader build() {
            return new RequestHeader(this);
        }
    }

    public static abstract class RequestHeaderBuilder<C extends RequestHeader, B extends RequestHeaderBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private NodeId authenticationToken;
        private DateTime timestamp;
        private UInteger requestHandle;
        private UInteger returnDiagnostics;
        private String auditEntryId;
        private UInteger timeoutHint;
        private ExtensionObject additionalHeader;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            RequestHeaderBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(RequestHeader instance, RequestHeaderBuilder<?, ?> b) {
            b.authenticationToken(instance.authenticationToken);
            b.timestamp(instance.timestamp);
            b.requestHandle(instance.requestHandle);
            b.returnDiagnostics(instance.returnDiagnostics);
            b.auditEntryId(instance.auditEntryId);
            b.timeoutHint(instance.timeoutHint);
            b.additionalHeader(instance.additionalHeader);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B authenticationToken(NodeId authenticationToken) {
            this.authenticationToken = authenticationToken;
            return (B)this.self();
        }

        public B timestamp(DateTime timestamp) {
            this.timestamp = timestamp;
            return (B)this.self();
        }

        public B requestHandle(UInteger requestHandle) {
            this.requestHandle = requestHandle;
            return (B)this.self();
        }

        public B returnDiagnostics(UInteger returnDiagnostics) {
            this.returnDiagnostics = returnDiagnostics;
            return (B)this.self();
        }

        public B auditEntryId(String auditEntryId) {
            this.auditEntryId = auditEntryId;
            return (B)this.self();
        }

        public B timeoutHint(UInteger timeoutHint) {
            this.timeoutHint = timeoutHint;
            return (B)this.self();
        }

        public B additionalHeader(ExtensionObject additionalHeader) {
            this.additionalHeader = additionalHeader;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "RequestHeader.RequestHeaderBuilder(super=" + super.toString() + ", authenticationToken=" + this.authenticationToken + ", timestamp=" + this.timestamp + ", requestHandle=" + this.requestHandle + ", returnDiagnostics=" + this.returnDiagnostics + ", auditEntryId=" + this.auditEntryId + ", timeoutHint=" + this.timeoutHint + ", additionalHeader=" + this.additionalHeader + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<RequestHeader> {
        @Override
        public Class<RequestHeader> getType() {
            return RequestHeader.class;
        }

        @Override
        public RequestHeader decode(SerializationContext context, UaDecoder decoder) {
            NodeId authenticationToken = decoder.readNodeId("AuthenticationToken");
            DateTime timestamp = decoder.readDateTime("Timestamp");
            UInteger requestHandle = decoder.readUInt32("RequestHandle");
            UInteger returnDiagnostics = decoder.readUInt32("ReturnDiagnostics");
            String auditEntryId = decoder.readString("AuditEntryId");
            UInteger timeoutHint = decoder.readUInt32("TimeoutHint");
            ExtensionObject additionalHeader = decoder.readExtensionObject("AdditionalHeader");
            return new RequestHeader(authenticationToken, timestamp, requestHandle, returnDiagnostics, auditEntryId, timeoutHint, additionalHeader);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, RequestHeader value) {
            encoder.writeNodeId("AuthenticationToken", value.getAuthenticationToken());
            encoder.writeDateTime("Timestamp", value.getTimestamp());
            encoder.writeUInt32("RequestHandle", value.getRequestHandle());
            encoder.writeUInt32("ReturnDiagnostics", value.getReturnDiagnostics());
            encoder.writeString("AuditEntryId", value.getAuditEntryId());
            encoder.writeUInt32("TimeoutHint", value.getTimeoutHint());
            encoder.writeExtensionObject("AdditionalHeader", value.getAdditionalHeader());
        }
    }
}

