/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.runtime;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.RecoverProgressIndex;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeCriticalException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.pipe.agent.runtime.PipePeriodicalJobExecutor;
import org.apache.iotdb.commons.pipe.agent.runtime.PipePeriodicalPhantomReferenceCleaner;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBPipePattern;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.resource.log.PipeLogger;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.agent.runtime.PipeAgentLauncher;
import org.apache.iotdb.db.pipe.agent.runtime.PipeSchemaRegionListenerManager;
import org.apache.iotdb.db.pipe.agent.runtime.SimpleProgressIndexAssigner;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeHardlinkOrCopiedFileDirStartupCleaner;
import org.apache.iotdb.db.pipe.resource.log.PipePeriodicalLogReducer;
import org.apache.iotdb.db.pipe.source.schemaregion.SchemaRegionListeningQueue;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.service.ResourcesInformationHolder;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionPathUtils;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeDataNodeRuntimeAgent
implements IService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeDataNodeRuntimeAgent.class);
    private static final int DATA_NODE_ID = IoTDBDescriptor.getInstance().getConfig().getDataNodeId();
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    private final PipeSchemaRegionListenerManager regionListenerManager = new PipeSchemaRegionListenerManager();
    private final SimpleProgressIndexAssigner simpleProgressIndexAssigner = new SimpleProgressIndexAssigner();
    private final PipePeriodicalJobExecutor pipePeriodicalJobExecutor = new PipePeriodicalJobExecutor();
    private final PipePeriodicalPhantomReferenceCleaner pipePeriodicalPhantomReferenceCleaner = new PipePeriodicalPhantomReferenceCleaner();

    public synchronized void preparePipeResources(ResourcesInformationHolder resourcesInformationHolder) throws StartupException {
        PipeDataNodeHardlinkOrCopiedFileDirStartupCleaner.clean();
        PipeDataNodeAgent.receiver().cleanPipeReceiverDirs();
        PipeAgentLauncher.launchPipePluginAgent(resourcesInformationHolder);
        this.simpleProgressIndexAssigner.start();
        IoTDBPipePattern.setDevicePathGetter(CompactionPathUtils::getPath);
        IoTDBPipePattern.setMeasurementPathGetter(CompactionPathUtils::getPath);
        PipeLogger.setLogger(PipePeriodicalLogReducer::log);
    }

    public synchronized void start() throws StartupException {
        PipeConfig.getInstance().printAllConfigs();
        PipeAgentLauncher.launchPipeTaskAgent();
        this.pipePeriodicalJobExecutor.start();
        if (PipeConfig.getInstance().getPipeEventReferenceTrackingEnabled()) {
            this.pipePeriodicalPhantomReferenceCleaner.start();
        }
        this.isShutdown.set(false);
    }

    public synchronized void stop() {
        if (this.isShutdown.get()) {
            return;
        }
        this.isShutdown.set(true);
        this.pipePeriodicalJobExecutor.stop();
        PipeDataNodeAgent.task().dropAllPipeTasks();
    }

    public boolean isShutdown() {
        return this.isShutdown.get();
    }

    public ServiceType getID() {
        return ServiceType.PIPE_RUNTIME_DATA_NODE_AGENT;
    }

    public Set<SchemaRegionId> listeningSchemaRegionIds() {
        return this.regionListenerManager.regionIds();
    }

    public SchemaRegionListeningQueue schemaListener(SchemaRegionId schemaRegionId) {
        return this.regionListenerManager.listener(schemaRegionId);
    }

    public int increaseAndGetSchemaListenerReferenceCount(SchemaRegionId schemaRegionId) {
        return this.regionListenerManager.increaseAndGetReferenceCount(schemaRegionId);
    }

    public int decreaseAndGetSchemaListenerReferenceCount(SchemaRegionId schemaRegionId) {
        return this.regionListenerManager.decreaseAndGetReferenceCount(schemaRegionId);
    }

    public void notifySchemaLeaderReady(SchemaRegionId schemaRegionId) {
        this.regionListenerManager.notifyLeaderReady(schemaRegionId);
    }

    public void notifySchemaLeaderUnavailable(SchemaRegionId schemaRegionId) {
        this.regionListenerManager.notifyLeaderUnavailable(schemaRegionId);
    }

    public boolean isSchemaLeaderReady(SchemaRegionId schemaRegionId) {
        return this.regionListenerManager.isLeaderReady(schemaRegionId);
    }

    public void assignSimpleProgressIndexIfNeeded(InsertNode insertNode) {
        this.simpleProgressIndexAssigner.assignIfNeeded(insertNode);
    }

    public ProgressIndex assignProgressIndexForPipeConsensus() {
        return new RecoverProgressIndex(DATA_NODE_ID, this.simpleProgressIndexAssigner.getSimpleProgressIndex());
    }

    public void assignProgressIndexForTsFileLoad(TsFileResource tsFileResource) {
        tsFileResource.setProgressIndex((ProgressIndex)this.getNextProgressIndexForTsFileLoad());
    }

    public RecoverProgressIndex getNextProgressIndexForTsFileLoad() {
        return new RecoverProgressIndex(-DATA_NODE_ID, this.simpleProgressIndexAssigner.getSimpleProgressIndex());
    }

    public void assignProgressIndexForTsFileRecovery(TsFileResource tsFileResource) {
        tsFileResource.updateProgressIndex((ProgressIndex)new RecoverProgressIndex(DATA_NODE_ID, this.simpleProgressIndexAssigner.getSimpleProgressIndex()));
    }

    public int getRebootTimes() {
        return this.simpleProgressIndexAssigner.getRebootTimes();
    }

    public void report(EnrichedEvent event, PipeRuntimeException pipeRuntimeException) {
        if (event.getPipeTaskMeta() != null) {
            this.report(event.getPipeTaskMeta(), pipeRuntimeException);
        } else {
            LOGGER.warn("Attempt to report pipe exception to a null PipeTaskMeta.", (Throwable)pipeRuntimeException);
        }
    }

    public void report(PipeTaskMeta pipeTaskMeta, PipeRuntimeException pipeRuntimeException) {
        LOGGER.warn("Report PipeRuntimeException to local PipeTaskMeta({}), exception message: {}", new Object[]{pipeTaskMeta, pipeRuntimeException.getMessage(), pipeRuntimeException});
        if (pipeRuntimeException instanceof PipeRuntimeCriticalException) {
            PipeDataNodeAgent.task().stopAllPipesWithCriticalExceptionAndTrackException(pipeTaskMeta, pipeRuntimeException);
        }
    }

    public void registerPeriodicalJob(String id, Runnable periodicalJob, long intervalInSeconds) {
        this.pipePeriodicalJobExecutor.register(id, periodicalJob, intervalInSeconds);
    }

    public void startPeriodicalJobExecutor() {
        this.pipePeriodicalJobExecutor.start();
    }

    public void stopPeriodicalJobExecutor() {
        this.pipePeriodicalJobExecutor.stop();
    }

    public void clearPeriodicalJobExecutor() {
        this.pipePeriodicalJobExecutor.clear();
    }

    public void registerPhantomReferenceCleanJob(String id, Runnable periodicalJob, long intervalInSeconds) {
        this.pipePeriodicalPhantomReferenceCleaner.register(id, periodicalJob, intervalInSeconds);
    }
}

