/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes.delegates;

import org.eclipse.milo.opcua.sdk.core.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.GetSetBase;
import org.eclipse.milo.opcua.sdk.server.util.AttributeUtil;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public interface GetSetVariableNode
extends GetSetBase {
    default public DataValue getVariableAttribute(AttributeContext context, UaVariableNode node, AttributeId attributeId) throws UaException {
        switch (attributeId) {
            case Value: {
                return this.getValue(context, node);
            }
            case DataType: {
                return AttributeUtil.dv(this.getDataType(context, node));
            }
            case ValueRank: {
                return AttributeUtil.dv(this.getValueRank(context, node));
            }
            case ArrayDimensions: {
                return AttributeUtil.dv(this.getArrayDimensions(context, node));
            }
            case AccessLevel: {
                return AttributeUtil.dv(this.getAccessLevel(context, node));
            }
            case UserAccessLevel: {
                return AttributeUtil.dv(this.getUserAccessLevel(context, node));
            }
            case MinimumSamplingInterval: {
                return AttributeUtil.dv(this.getMinimumSamplingInterval(context, node));
            }
            case Historizing: {
                return AttributeUtil.dv(this.getHistorizing(context, node));
            }
        }
        return this.getBaseAttribute(context, node, attributeId);
    }

    default public void setVariableAttribute(AttributeContext context, UaVariableNode node, AttributeId attributeId, DataValue value) throws UaException {
        switch (attributeId) {
            case Value: {
                this.setValue(context, node, value);
                break;
            }
            case DataType: {
                this.setDataType(context, node, (NodeId)AttributeUtil.extract(value));
                break;
            }
            case ValueRank: {
                this.setValueRank(context, node, (Integer)AttributeUtil.extract(value));
                break;
            }
            case ArrayDimensions: {
                this.setArrayDimensions(context, node, (UInteger[])AttributeUtil.extract(value));
                break;
            }
            case AccessLevel: {
                this.setAccessLevel(context, node, (UByte)AttributeUtil.extract(value));
                break;
            }
            case UserAccessLevel: {
                this.setUserAccessLevel(context, node, (UByte)AttributeUtil.extract(value));
                break;
            }
            case MinimumSamplingInterval: {
                this.setMinimumSamplingInterval(context, node, (Double)AttributeUtil.extract(value));
                break;
            }
            case Historizing: {
                this.setHistorizing(context, node, (Boolean)AttributeUtil.extract(value));
                break;
            }
            default: {
                this.setBaseAttribute(context, node, attributeId, value);
            }
        }
    }

    default public DataValue getValue(AttributeContext context, VariableNode node) throws UaException {
        return (DataValue)((UaNode)node).getFilterChain().getAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.Value);
    }

    default public NodeId getDataType(AttributeContext context, VariableNode node) throws UaException {
        return (NodeId)((UaNode)node).getFilterChain().getAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.DataType);
    }

    default public Integer getValueRank(AttributeContext context, VariableNode node) throws UaException {
        return (Integer)((UaNode)node).getFilterChain().getAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.ValueRank);
    }

    default public UInteger[] getArrayDimensions(AttributeContext context, VariableNode node) throws UaException {
        return (UInteger[])((UaNode)node).getFilterChain().getAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.ArrayDimensions);
    }

    default public UByte getAccessLevel(AttributeContext context, VariableNode node) throws UaException {
        return (UByte)((UaNode)node).getFilterChain().getAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.AccessLevel);
    }

    default public UByte getUserAccessLevel(AttributeContext context, VariableNode node) throws UaException {
        return (UByte)((UaNode)node).getFilterChain().getAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.UserAccessLevel);
    }

    default public Double getMinimumSamplingInterval(AttributeContext context, VariableNode node) throws UaException {
        return (Double)((UaNode)node).getFilterChain().getAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.MinimumSamplingInterval);
    }

    default public Boolean getHistorizing(AttributeContext context, VariableNode node) throws UaException {
        return (Boolean)((UaNode)node).getFilterChain().getAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.Historizing);
    }

    default public void setValue(AttributeContext context, VariableNode node, DataValue value) throws UaException {
        ((UaNode)node).getFilterChain().setAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.Value, value);
    }

    default public void setDataType(AttributeContext context, VariableNode node, NodeId dataType) throws UaException {
        ((UaNode)node).getFilterChain().setAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.DataType, dataType);
    }

    default public void setValueRank(AttributeContext context, VariableNode node, Integer valueRank) throws UaException {
        ((UaNode)node).getFilterChain().setAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.ValueRank, valueRank);
    }

    default public void setArrayDimensions(AttributeContext context, VariableNode node, UInteger[] arrayDimensions) throws UaException {
        ((UaNode)node).getFilterChain().setAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.ArrayDimensions, arrayDimensions);
    }

    default public void setAccessLevel(AttributeContext context, VariableNode node, UByte accessLevel) throws UaException {
        ((UaNode)node).getFilterChain().setAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.AccessLevel, accessLevel);
    }

    default public void setUserAccessLevel(AttributeContext context, VariableNode node, UByte userAccessLevel) throws UaException {
        ((UaNode)node).getFilterChain().setAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.UserAccessLevel, userAccessLevel);
    }

    default public void setMinimumSamplingInterval(AttributeContext context, VariableNode node, Double minimumSamplingInterval) throws UaException {
        ((UaNode)node).getFilterChain().setAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.MinimumSamplingInterval, minimumSamplingInterval);
    }

    default public void setHistorizing(AttributeContext context, VariableNode node, Boolean historizing) throws UaException {
        ((UaNode)node).getFilterChain().setAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.Historizing, historizing);
    }
}

