/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.window.ainode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.execution.operator.window.ainode.InferenceWindowParameter;
import org.apache.iotdb.db.queryengine.execution.operator.window.ainode.InferenceWindowType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class CountInferenceWindowParameter
extends InferenceWindowParameter {
    private final long interval;
    private final long step;

    public CountInferenceWindowParameter(long interval, long step) {
        this.windowType = InferenceWindowType.COUNT;
        this.interval = interval;
        this.step = step;
    }

    public long getInterval() {
        return this.interval;
    }

    public long getStep() {
        return this.step;
    }

    @Override
    public void serializeAttributes(ByteBuffer buffer) {
        ReadWriteIOUtils.write((long)this.interval, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((long)this.step, (ByteBuffer)buffer);
    }

    @Override
    public void serializeAttributes(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((long)this.interval, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.step, (OutputStream)stream);
    }

    public static CountInferenceWindowParameter deserialize(ByteBuffer byteBuffer) {
        long interval = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        long step = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        return new CountInferenceWindowParameter(interval, step);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CountInferenceWindowParameter)) {
            return false;
        }
        CountInferenceWindowParameter parameter = (CountInferenceWindowParameter)obj;
        return this.interval == parameter.interval && this.step == parameter.step;
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.step);
    }
}

