/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.subscription.config;

import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionConfig {
    private static final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionConfig.class);

    public boolean getSubscriptionEnabled() {
        return COMMON_CONFIG.getSubscriptionEnabled();
    }

    public float getSubscriptionCacheMemoryUsagePercentage() {
        return COMMON_CONFIG.getSubscriptionCacheMemoryUsagePercentage();
    }

    public int getSubscriptionSubtaskExecutorMaxThreadNum() {
        return COMMON_CONFIG.getSubscriptionSubtaskExecutorMaxThreadNum();
    }

    public int getSubscriptionPrefetchTabletBatchMaxDelayInMs() {
        return COMMON_CONFIG.getSubscriptionPrefetchTabletBatchMaxDelayInMs();
    }

    public long getSubscriptionPrefetchTabletBatchMaxSizeInBytes() {
        return COMMON_CONFIG.getSubscriptionPrefetchTabletBatchMaxSizeInBytes();
    }

    public int getSubscriptionPrefetchTsFileBatchMaxDelayInMs() {
        return COMMON_CONFIG.getSubscriptionPrefetchTsFileBatchMaxDelayInMs();
    }

    public long getSubscriptionPrefetchTsFileBatchMaxSizeInBytes() {
        return COMMON_CONFIG.getSubscriptionPrefetchTsFileBatchMaxSizeInBytes();
    }

    public int getSubscriptionPollMaxBlockingTimeMs() {
        return COMMON_CONFIG.getSubscriptionPollMaxBlockingTimeMs();
    }

    public int getSubscriptionDefaultTimeoutInMs() {
        return COMMON_CONFIG.getSubscriptionDefaultTimeoutInMs();
    }

    public long getSubscriptionLaunchRetryIntervalMs() {
        return COMMON_CONFIG.getSubscriptionLaunchRetryIntervalMs();
    }

    public int getSubscriptionRecycleUncommittedEventIntervalMs() {
        return COMMON_CONFIG.getSubscriptionRecycleUncommittedEventIntervalMs();
    }

    public long getSubscriptionReadFileBufferSize() {
        return COMMON_CONFIG.getSubscriptionReadFileBufferSize();
    }

    public long getSubscriptionReadTabletBufferSize() {
        return COMMON_CONFIG.getSubscriptionReadTabletBufferSize();
    }

    public long getSubscriptionTsFileDeduplicationWindowSeconds() {
        return COMMON_CONFIG.getSubscriptionTsFileDeduplicationWindowSeconds();
    }

    public long getSubscriptionCheckMemoryEnoughIntervalMs() {
        return COMMON_CONFIG.getSubscriptionCheckMemoryEnoughIntervalMs();
    }

    public long getSubscriptionEstimatedInsertNodeTabletInsertionEventSize() {
        return COMMON_CONFIG.getSubscriptionEstimatedInsertNodeTabletInsertionEventSize();
    }

    public long getSubscriptionEstimatedRawTabletInsertionEventSize() {
        return COMMON_CONFIG.getSubscriptionEstimatedRawTabletInsertionEventSize();
    }

    public long getSubscriptionMaxAllowedEventCountInTabletBatch() {
        return COMMON_CONFIG.getSubscriptionMaxAllowedEventCountInTabletBatch();
    }

    public long getSubscriptionLogManagerWindowSeconds() {
        return COMMON_CONFIG.getSubscriptionLogManagerWindowSeconds();
    }

    public long getSubscriptionLogManagerBaseIntervalMs() {
        return COMMON_CONFIG.getSubscriptionLogManagerBaseIntervalMs();
    }

    public boolean getSubscriptionPrefetchEnabled() {
        return COMMON_CONFIG.getSubscriptionPrefetchEnabled();
    }

    public float getSubscriptionPrefetchMemoryThreshold() {
        return COMMON_CONFIG.getSubscriptionPrefetchMemoryThreshold();
    }

    public float getSubscriptionPrefetchMissingRateThreshold() {
        return COMMON_CONFIG.getSubscriptionPrefetchMissingRateThreshold();
    }

    public int getSubscriptionPrefetchEventLocalCountThreshold() {
        return COMMON_CONFIG.getSubscriptionPrefetchEventLocalCountThreshold();
    }

    public int getSubscriptionPrefetchEventGlobalCountThreshold() {
        return COMMON_CONFIG.getSubscriptionPrefetchEventGlobalCountThreshold();
    }

    public long getSubscriptionMetaSyncerInitialSyncDelayMinutes() {
        return COMMON_CONFIG.getSubscriptionMetaSyncerInitialSyncDelayMinutes();
    }

    public long getSubscriptionMetaSyncerSyncIntervalMinutes() {
        return COMMON_CONFIG.getSubscriptionMetaSyncerSyncIntervalMinutes();
    }

    public void printAllConfigs() {
        LOGGER.info("SubscriptionEnabled: {}", (Object)this.getSubscriptionEnabled());
        LOGGER.info("SubscriptionCacheMemoryUsagePercentage: {}", (Object)Float.valueOf(this.getSubscriptionCacheMemoryUsagePercentage()));
        LOGGER.info("SubscriptionSubtaskExecutorMaxThreadNum: {}", (Object)this.getSubscriptionSubtaskExecutorMaxThreadNum());
        LOGGER.info("SubscriptionPrefetchTabletBatchMaxDelayInMs: {}", (Object)this.getSubscriptionPrefetchTabletBatchMaxDelayInMs());
        LOGGER.info("SubscriptionPrefetchTabletBatchMaxSizeInBytes: {}", (Object)this.getSubscriptionPrefetchTabletBatchMaxSizeInBytes());
        LOGGER.info("SubscriptionPrefetchTsFileBatchMaxDelayInMs: {}", (Object)this.getSubscriptionPrefetchTsFileBatchMaxDelayInMs());
        LOGGER.info("SubscriptionPrefetchTsFileBatchMaxSizeInBytes: {}", (Object)this.getSubscriptionPrefetchTsFileBatchMaxSizeInBytes());
        LOGGER.info("SubscriptionPollMaxBlockingTimeMs: {}", (Object)this.getSubscriptionPollMaxBlockingTimeMs());
        LOGGER.info("SubscriptionDefaultTimeoutInMs: {}", (Object)this.getSubscriptionDefaultTimeoutInMs());
        LOGGER.info("SubscriptionLaunchRetryIntervalMs: {}", (Object)this.getSubscriptionLaunchRetryIntervalMs());
        LOGGER.info("SubscriptionRecycleUncommittedEventIntervalMs: {}", (Object)this.getSubscriptionRecycleUncommittedEventIntervalMs());
        LOGGER.info("SubscriptionReadFileBufferSize: {}", (Object)this.getSubscriptionReadFileBufferSize());
        LOGGER.info("SubscriptionReadTabletBufferSize: {}", (Object)this.getSubscriptionReadTabletBufferSize());
        LOGGER.info("SubscriptionTsFileDeduplicationWindowSeconds: {}", (Object)this.getSubscriptionTsFileDeduplicationWindowSeconds());
        LOGGER.info("SubscriptionCheckMemoryEnoughIntervalMs: {}", (Object)this.getSubscriptionCheckMemoryEnoughIntervalMs());
        LOGGER.info("SubscriptionEstimatedInsertNodeTabletInsertionEventSize: {}", (Object)this.getSubscriptionEstimatedInsertNodeTabletInsertionEventSize());
        LOGGER.info("SubscriptionEstimatedRawTabletInsertionEventSize: {}", (Object)this.getSubscriptionEstimatedRawTabletInsertionEventSize());
        LOGGER.info("SubscriptionMaxAllowedEventCountInTabletBatch: {}", (Object)this.getSubscriptionMaxAllowedEventCountInTabletBatch());
        LOGGER.info("SubscriptionLogManagerWindowSeconds: {}", (Object)this.getSubscriptionLogManagerWindowSeconds());
        LOGGER.info("SubscriptionLogManagerBaseIntervalMs: {}", (Object)this.getSubscriptionLogManagerBaseIntervalMs());
        LOGGER.info("SubscriptionPrefetchEnabled: {}", (Object)this.getSubscriptionPrefetchEnabled());
        LOGGER.info("SubscriptionPrefetchMemoryThreshold: {}", (Object)Float.valueOf(this.getSubscriptionPrefetchMemoryThreshold()));
        LOGGER.info("SubscriptionPrefetchMissingRateThreshold: {}", (Object)Float.valueOf(this.getSubscriptionPrefetchMissingRateThreshold()));
        LOGGER.info("SubscriptionPrefetchEventLocalCountThreshold: {}", (Object)this.getSubscriptionPrefetchEventLocalCountThreshold());
        LOGGER.info("SubscriptionPrefetchEventGlobalCountThreshold: {}", (Object)this.getSubscriptionPrefetchEventGlobalCountThreshold());
        LOGGER.info("SubscriptionMetaSyncerInitialSyncDelayMinutes: {}", (Object)this.getSubscriptionMetaSyncerInitialSyncDelayMinutes());
        LOGGER.info("SubscriptionMetaSyncerSyncIntervalMinutes: {}", (Object)this.getSubscriptionMetaSyncerSyncIntervalMinutes());
    }

    private SubscriptionConfig() {
    }

    public static SubscriptionConfig getInstance() {
        return SubscriptionConfigHolder.INSTANCE;
    }

    private static class SubscriptionConfigHolder {
        private static final SubscriptionConfig INSTANCE = new SubscriptionConfig();

        private SubscriptionConfigHolder() {
        }
    }
}

