/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class EndpointUrlListDataType
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=11943");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=11949");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=11957");
    private final String[] endpointUrlList;

    public EndpointUrlListDataType(String[] endpointUrlList) {
        this.endpointUrlList = endpointUrlList;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public String[] getEndpointUrlList() {
        return this.endpointUrlList;
    }

    protected EndpointUrlListDataType(EndpointUrlListDataTypeBuilder<?, ?> b) {
        super(b);
        this.endpointUrlList = ((EndpointUrlListDataTypeBuilder)b).endpointUrlList;
    }

    public static EndpointUrlListDataTypeBuilder<?, ?> builder() {
        return new EndpointUrlListDataTypeBuilderImpl();
    }

    public EndpointUrlListDataTypeBuilder<?, ?> toBuilder() {
        return new EndpointUrlListDataTypeBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EndpointUrlListDataType)) {
            return false;
        }
        EndpointUrlListDataType other = (EndpointUrlListDataType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getEndpointUrlList(), other.getEndpointUrlList());
    }

    protected boolean canEqual(Object other) {
        return other instanceof EndpointUrlListDataType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getEndpointUrlList());
        return result;
    }

    @Override
    public String toString() {
        return "EndpointUrlListDataType(endpointUrlList=" + Arrays.deepToString(this.getEndpointUrlList()) + ")";
    }

    private static final class EndpointUrlListDataTypeBuilderImpl
    extends EndpointUrlListDataTypeBuilder<EndpointUrlListDataType, EndpointUrlListDataTypeBuilderImpl> {
        private EndpointUrlListDataTypeBuilderImpl() {
        }

        @Override
        protected EndpointUrlListDataTypeBuilderImpl self() {
            return this;
        }

        @Override
        public EndpointUrlListDataType build() {
            return new EndpointUrlListDataType(this);
        }
    }

    public static abstract class EndpointUrlListDataTypeBuilder<C extends EndpointUrlListDataType, B extends EndpointUrlListDataTypeBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private String[] endpointUrlList;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            EndpointUrlListDataTypeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(EndpointUrlListDataType instance, EndpointUrlListDataTypeBuilder<?, ?> b) {
            b.endpointUrlList(instance.endpointUrlList);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B endpointUrlList(String[] endpointUrlList) {
            this.endpointUrlList = endpointUrlList;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "EndpointUrlListDataType.EndpointUrlListDataTypeBuilder(super=" + super.toString() + ", endpointUrlList=" + Arrays.deepToString(this.endpointUrlList) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<EndpointUrlListDataType> {
        @Override
        public Class<EndpointUrlListDataType> getType() {
            return EndpointUrlListDataType.class;
        }

        @Override
        public EndpointUrlListDataType decode(SerializationContext context, UaDecoder decoder) {
            String[] endpointUrlList = decoder.readStringArray("EndpointUrlList");
            return new EndpointUrlListDataType(endpointUrlList);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, EndpointUrlListDataType value) {
            encoder.writeStringArray("EndpointUrlList", value.getEndpointUrlList());
        }
    }
}

