/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.AI;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.model.ModelInferenceDescriptor;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class InferenceNode
extends SingleChildProcessNode {
    private final ModelInferenceDescriptor modelInferenceDescriptor;
    private final List<String> targetColumnNames;
    private boolean generateTimeColumn = false;

    public InferenceNode(PlanNodeId id, PlanNode child, ModelInferenceDescriptor modelInferenceDescriptor, boolean generateTimeColumn, List<String> targetColumnNames) {
        super(id, child);
        this.modelInferenceDescriptor = modelInferenceDescriptor;
        this.targetColumnNames = targetColumnNames;
        this.generateTimeColumn = generateTimeColumn;
    }

    public InferenceNode(PlanNodeId id, ModelInferenceDescriptor modelInferenceDescriptor, boolean generateTimeColumn, List<String> inputColumnNames) {
        super(id);
        this.modelInferenceDescriptor = modelInferenceDescriptor;
        this.targetColumnNames = inputColumnNames;
        this.generateTimeColumn = generateTimeColumn;
    }

    public ModelInferenceDescriptor getModelInferenceDescriptor() {
        return this.modelInferenceDescriptor;
    }

    public List<String> getInputColumnNames() {
        return this.targetColumnNames;
    }

    public boolean isGenerateTimeColumn() {
        return this.generateTimeColumn;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitInference(this, context);
    }

    @Override
    public PlanNode clone() {
        return new InferenceNode(this.getPlanNodeId(), this.child, this.modelInferenceDescriptor, this.generateTimeColumn, this.targetColumnNames);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.modelInferenceDescriptor.getOutputColumnNames();
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.INFERENCE.serialize(byteBuffer);
        this.modelInferenceDescriptor.serialize(byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.generateTimeColumn, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.writeStringList(this.targetColumnNames, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.INFERENCE.serialize(stream);
        this.modelInferenceDescriptor.serialize(stream);
        ReadWriteIOUtils.write((Boolean)this.generateTimeColumn, (OutputStream)stream);
        ReadWriteIOUtils.writeStringList(this.targetColumnNames, (OutputStream)stream);
    }

    public static InferenceNode deserialize(ByteBuffer buffer) {
        ModelInferenceDescriptor modelInferenceDescriptor = ModelInferenceDescriptor.deserialize(buffer);
        boolean generateTimeColumn = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        List inputColumnNames = ReadWriteIOUtils.readStringList((ByteBuffer)buffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(buffer);
        return new InferenceNode(planNodeId, modelInferenceDescriptor, generateTimeColumn, inputColumnNames);
    }

    public String toString() {
        return "InferenceNode-" + this.getPlanNodeId();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InferenceNode that = (InferenceNode)o;
        return this.modelInferenceDescriptor.equals(that.modelInferenceDescriptor) && this.targetColumnNames.equals(that.targetColumnNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.modelInferenceDescriptor, this.targetColumnNames);
    }
}

