/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class CallMethodRequest
extends Structure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=704");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=706");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=705");
    private final NodeId objectId;
    private final NodeId methodId;
    private final Variant[] inputArguments;

    public CallMethodRequest(NodeId objectId, NodeId methodId, Variant[] inputArguments) {
        this.objectId = objectId;
        this.methodId = methodId;
        this.inputArguments = inputArguments;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public NodeId getObjectId() {
        return this.objectId;
    }

    public NodeId getMethodId() {
        return this.methodId;
    }

    public Variant[] getInputArguments() {
        return this.inputArguments;
    }

    protected CallMethodRequest(CallMethodRequestBuilder<?, ?> b) {
        super(b);
        this.objectId = ((CallMethodRequestBuilder)b).objectId;
        this.methodId = ((CallMethodRequestBuilder)b).methodId;
        this.inputArguments = ((CallMethodRequestBuilder)b).inputArguments;
    }

    public static CallMethodRequestBuilder<?, ?> builder() {
        return new CallMethodRequestBuilderImpl();
    }

    public CallMethodRequestBuilder<?, ?> toBuilder() {
        return new CallMethodRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CallMethodRequest)) {
            return false;
        }
        CallMethodRequest other = (CallMethodRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NodeId this$objectId = this.getObjectId();
        NodeId other$objectId = other.getObjectId();
        if (this$objectId == null ? other$objectId != null : !((Object)this$objectId).equals(other$objectId)) {
            return false;
        }
        NodeId this$methodId = this.getMethodId();
        NodeId other$methodId = other.getMethodId();
        if (this$methodId == null ? other$methodId != null : !((Object)this$methodId).equals(other$methodId)) {
            return false;
        }
        return Arrays.deepEquals(this.getInputArguments(), other.getInputArguments());
    }

    protected boolean canEqual(Object other) {
        return other instanceof CallMethodRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NodeId $objectId = this.getObjectId();
        result = result * 59 + ($objectId == null ? 43 : ((Object)$objectId).hashCode());
        NodeId $methodId = this.getMethodId();
        result = result * 59 + ($methodId == null ? 43 : ((Object)$methodId).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getInputArguments());
        return result;
    }

    @Override
    public String toString() {
        return "CallMethodRequest(objectId=" + this.getObjectId() + ", methodId=" + this.getMethodId() + ", inputArguments=" + Arrays.deepToString(this.getInputArguments()) + ")";
    }

    private static final class CallMethodRequestBuilderImpl
    extends CallMethodRequestBuilder<CallMethodRequest, CallMethodRequestBuilderImpl> {
        private CallMethodRequestBuilderImpl() {
        }

        @Override
        protected CallMethodRequestBuilderImpl self() {
            return this;
        }

        @Override
        public CallMethodRequest build() {
            return new CallMethodRequest(this);
        }
    }

    public static abstract class CallMethodRequestBuilder<C extends CallMethodRequest, B extends CallMethodRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private NodeId objectId;
        private NodeId methodId;
        private Variant[] inputArguments;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CallMethodRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(CallMethodRequest instance, CallMethodRequestBuilder<?, ?> b) {
            b.objectId(instance.objectId);
            b.methodId(instance.methodId);
            b.inputArguments(instance.inputArguments);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B objectId(NodeId objectId) {
            this.objectId = objectId;
            return (B)this.self();
        }

        public B methodId(NodeId methodId) {
            this.methodId = methodId;
            return (B)this.self();
        }

        public B inputArguments(Variant[] inputArguments) {
            this.inputArguments = inputArguments;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "CallMethodRequest.CallMethodRequestBuilder(super=" + super.toString() + ", objectId=" + this.objectId + ", methodId=" + this.methodId + ", inputArguments=" + Arrays.deepToString(this.inputArguments) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<CallMethodRequest> {
        @Override
        public Class<CallMethodRequest> getType() {
            return CallMethodRequest.class;
        }

        @Override
        public CallMethodRequest decode(SerializationContext context, UaDecoder decoder) {
            NodeId objectId = decoder.readNodeId("ObjectId");
            NodeId methodId = decoder.readNodeId("MethodId");
            Variant[] inputArguments = decoder.readVariantArray("InputArguments");
            return new CallMethodRequest(objectId, methodId, inputArguments);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, CallMethodRequest value) {
            encoder.writeNodeId("ObjectId", value.getObjectId());
            encoder.writeNodeId("MethodId", value.getMethodId());
            encoder.writeVariantArray("InputArguments", value.getInputArguments());
        }
    }
}

