/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.config;

import java.util.Optional;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.consensus.config.IoTConsensusConfig;
import org.apache.iotdb.consensus.config.PipeConsensusConfig;
import org.apache.iotdb.consensus.config.RatisConfig;

public class ConsensusConfig {
    private final TEndPoint thisNodeEndPoint;
    private final int thisNodeId;
    private final String storageDir;
    private final TConsensusGroupType consensusGroupType;
    private final RatisConfig ratisConfig;
    private final IoTConsensusConfig iotConsensusConfig;
    private final PipeConsensusConfig pipeConsensusConfig;

    private ConsensusConfig(TEndPoint thisNode, int thisNodeId, String storageDir, TConsensusGroupType consensusGroupType, RatisConfig ratisConfig, IoTConsensusConfig iotConsensusConfig, PipeConsensusConfig pipeConsensusConfig) {
        this.thisNodeEndPoint = thisNode;
        this.thisNodeId = thisNodeId;
        this.storageDir = storageDir;
        this.consensusGroupType = consensusGroupType;
        this.ratisConfig = ratisConfig;
        this.iotConsensusConfig = iotConsensusConfig;
        this.pipeConsensusConfig = pipeConsensusConfig;
    }

    public TEndPoint getThisNodeEndPoint() {
        return this.thisNodeEndPoint;
    }

    public int getThisNodeId() {
        return this.thisNodeId;
    }

    public String getStorageDir() {
        return this.storageDir;
    }

    public TConsensusGroupType getConsensusGroupType() {
        return this.consensusGroupType;
    }

    public RatisConfig getRatisConfig() {
        return this.ratisConfig;
    }

    public IoTConsensusConfig getIotConsensusConfig() {
        return this.iotConsensusConfig;
    }

    public PipeConsensusConfig getPipeConsensusConfig() {
        return this.pipeConsensusConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private TEndPoint thisNode;
        private int thisNodeId;
        private String storageDir;
        private TConsensusGroupType consensusGroupType;
        private RatisConfig ratisConfig;
        private IoTConsensusConfig iotConsensusConfig;
        private PipeConsensusConfig pipeConsensusConfig;

        public ConsensusConfig build() {
            return new ConsensusConfig(this.thisNode, this.thisNodeId, this.storageDir, this.consensusGroupType, Optional.ofNullable(this.ratisConfig).orElseGet(() -> RatisConfig.newBuilder().build()), Optional.ofNullable(this.iotConsensusConfig).orElseGet(() -> IoTConsensusConfig.newBuilder().build()), Optional.ofNullable(this.pipeConsensusConfig).orElseGet(() -> PipeConsensusConfig.newBuilder().build()));
        }

        public Builder setThisNode(TEndPoint thisNode) {
            this.thisNode = thisNode;
            return this;
        }

        public Builder setThisNodeId(int thisNodeId) {
            this.thisNodeId = thisNodeId;
            return this;
        }

        public Builder setStorageDir(String storageDir) {
            this.storageDir = storageDir;
            return this;
        }

        public Builder setConsensusGroupType(TConsensusGroupType groupType) {
            this.consensusGroupType = groupType;
            return this;
        }

        public Builder setRatisConfig(RatisConfig ratisConfig) {
            this.ratisConfig = ratisConfig;
            return this;
        }

        public Builder setIoTConsensusConfig(IoTConsensusConfig iotConsensusConfig) {
            this.iotConsensusConfig = iotConsensusConfig;
            return this;
        }

        public Builder setPipeConsensusConfig(PipeConsensusConfig pipeConsensusConfig) {
            this.pipeConsensusConfig = pipeConsensusConfig;
            return this;
        }
    }
}

