/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.util.concurrent;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite3.raft.jraft.util.Ints;
import org.apache.ignite3.raft.jraft.util.concurrent.ExecutorChooserFactory;
import org.apache.ignite3.raft.jraft.util.concurrent.SingleThreadExecutor;

public final class DefaultExecutorChooserFactory
implements ExecutorChooserFactory {
    public static final DefaultExecutorChooserFactory INSTANCE = new DefaultExecutorChooserFactory();

    @Override
    public ExecutorChooserFactory.ExecutorChooser newChooser(SingleThreadExecutor[] executors) {
        if (Ints.isPowerOfTwo(executors.length)) {
            return new PowerOfTwoExecutorChooser(executors);
        }
        return new GenericExecutorChooser(executors);
    }

    private DefaultExecutorChooserFactory() {
    }

    private static class PowerOfTwoExecutorChooser
    extends AbstractExecutorChooser {
        PowerOfTwoExecutorChooser(SingleThreadExecutor[] executors) {
            super(executors);
        }

        @Override
        public SingleThreadExecutor select(int index) {
            return this.executors[index & this.executors.length - 1];
        }
    }

    private static class GenericExecutorChooser
    extends AbstractExecutorChooser {
        protected GenericExecutorChooser(SingleThreadExecutor[] executors) {
            super(executors);
        }

        @Override
        public SingleThreadExecutor select(int index) {
            return this.executors[Math.abs(index % this.executors.length)];
        }
    }

    private static abstract class AbstractExecutorChooser
    implements ExecutorChooserFactory.ExecutorChooser {
        protected final AtomicInteger idx = new AtomicInteger();
        protected final SingleThreadExecutor[] executors;

        protected AbstractExecutorChooser(SingleThreadExecutor[] executors) {
            this.executors = executors;
        }

        @Override
        public SingleThreadExecutor next() {
            return this.select(this.idx.getAndIncrement());
        }
    }
}

