/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.session;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobSibling;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTaskSessionImpl;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class GridTaskSessionProcessor
extends GridProcessorAdapter {
    private final ConcurrentMap<IgniteUuid, GridTaskSessionImpl> sesMap = new ConcurrentHashMap<IgniteUuid, GridTaskSessionImpl>(2048);

    public GridTaskSessionProcessor(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public void start() throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Session processor started.");
        }
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Session processor stopped.");
        }
    }

    public GridTaskSessionImpl createTaskSession(IgniteUuid sesId, UUID taskNodeId, String taskName, @Nullable GridDeployment dep, String taskClsName, @Nullable Collection<UUID> top, @Nullable IgnitePredicate<ClusterNode> topPred, long startTime, long endTime, Collection<ComputeJobSibling> siblings, Map<Object, Object> attrs, boolean fullSup, boolean internal, @Nullable String execName, @Nullable SecurityContext secCtx) {
        if (!fullSup) {
            return new GridTaskSessionImpl(taskNodeId, taskName, dep, taskClsName, sesId, top, topPred, startTime, endTime, siblings, attrs, this.ctx, false, internal, execName, secCtx);
        }
        while (true) {
            GridTaskSessionImpl ses;
            if ((ses = (GridTaskSessionImpl)this.sesMap.get(sesId)) == null) {
                ses = new GridTaskSessionImpl(taskNodeId, taskName, dep, taskClsName, sesId, top, topPred, startTime, endTime, siblings, attrs, this.ctx, true, internal, execName, secCtx);
                GridTaskSessionImpl old = this.sesMap.putIfAbsent(sesId, ses);
                if (old != null) {
                    ses = old;
                } else {
                    return ses;
                }
            }
            if (ses.acquire()) {
                return ses;
            }
            this.sesMap.remove(sesId, ses);
        }
    }

    @Nullable
    public GridTaskSessionImpl getSession(IgniteUuid sesId) {
        return (GridTaskSessionImpl)this.sesMap.get(sesId);
    }

    public boolean removeSession(IgniteUuid sesId) {
        GridTaskSessionImpl ses = (GridTaskSessionImpl)this.sesMap.get(sesId);
        assert (ses == null || ses.isFullSupport());
        if (ses != null && ses.release()) {
            this.sesMap.remove(sesId, ses);
            return true;
        }
        return false;
    }

    @Override
    public void printMemoryStats() {
        X.println(">>>", new Object[0]);
        X.println(">>> Task session processor memory stats [igniteInstanceName=" + this.ctx.igniteInstanceName() + "]", new Object[0]);
        X.println(">>>  sesMapSize: " + this.sesMap.size(), new Object[0]);
    }
}

