/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.util.Collection;
import java.util.List;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.util.CollectionUtils;

public class NewSchemaEntry
implements UpdateEntry {
    private final CatalogSchemaDescriptor descriptor;

    public NewSchemaEntry(CatalogSchemaDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public CatalogSchemaDescriptor descriptor() {
        return this.descriptor;
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, HybridTimestamp timestamp) {
        this.descriptor.updateTimestamp(timestamp);
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), catalog.zones(), CollectionUtils.concat((Collection[])new Collection[]{catalog.schemas(), List.of(this.descriptor)}), catalog.defaultZone().id());
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.NEW_SCHEMA.id();
    }
}

