/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.sql.stat;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.ignite.internal.processors.query.calcite.sql.stat.IgniteSqlStatisticsAnalyzeOption;
import org.apache.ignite.internal.processors.query.calcite.sql.stat.IgniteSqlStatisticsCommand;
import org.apache.ignite.internal.util.typedef.F;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IgniteSqlStatisticsAnalyze
extends IgniteSqlStatisticsCommand {
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("ANALYZE", SqlKind.OTHER_DDL);
    private final SqlNodeList options;

    public IgniteSqlStatisticsAnalyze(SqlNodeList tables, @Nullable SqlNodeList options, SqlParserPos pos) {
        super(OPERATOR, tables, pos);
        this.options = options != null ? SqlNodeList.of((SqlParserPos)options.getParserPosition(), (List)options.getList()) : null;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.tables, (Object)this.options);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        if (!F.isEmpty((Collection)this.options)) {
            writer.keyword("WITH");
            this.options.unparse(writer, 0, 0);
        }
    }

    public List<IgniteSqlStatisticsAnalyzeOption> options() {
        if (this.options == null) {
            return Collections.emptyList();
        }
        return this.options.stream().map(IgniteSqlStatisticsAnalyzeOption.class::cast).collect(Collectors.toList());
    }
}

