/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rule;

import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.PhysicalNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteConvention;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteProject;
import org.apache.ignite.internal.processors.query.calcite.rule.AbstractIgniteConverterRule;
import org.apache.ignite.internal.processors.query.calcite.trait.CorrelationTrait;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistributions;
import org.apache.ignite.internal.processors.query.calcite.trait.RewindabilityTrait;
import org.apache.ignite.internal.processors.query.calcite.util.RexUtils;

public class ProjectConverterRule
extends AbstractIgniteConverterRule<LogicalProject> {
    public static final RelOptRule INSTANCE = new ProjectConverterRule();

    public ProjectConverterRule() {
        super(LogicalProject.class, "ProjectConverterRule");
    }

    @Override
    protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, LogicalProject rel) {
        RelOptCluster cluster = rel.getCluster();
        RelTraitSet traits = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)IgniteDistributions.single());
        Set<CorrelationId> corrIds = RexUtils.extractCorrelationIds(rel.getProjects());
        if (!corrIds.isEmpty()) {
            traits = traits.replace((RelTrait)CorrelationTrait.correlations(corrIds)).replace((RelTrait)RewindabilityTrait.REWINDABLE);
        }
        RelNode input = ProjectConverterRule.convert((RelNode)rel.getInput(), (RelTraitSet)traits);
        return new IgniteProject(cluster, traits, input, rel.getProjects(), rel.getRowType());
    }
}

