/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicHeaderValueParser;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestBasicHeaderValueParser {
    private BasicHeaderValueParser parser;

    TestBasicHeaderValueParser() {
    }

    @BeforeEach
    void setup() {
        this.parser = BasicHeaderValueParser.INSTANCE;
    }

    @Test
    void testParseHeaderElements() {
        String headerValue = "name1 = value1; name2; name3=\"value3\" , name4=value4; name5=value5, name6= ; name7 = value7; name8 = \" value8\"";
        CharArrayBuffer buf = new CharArrayBuffer(64);
        buf.append("name1 = value1; name2; name3=\"value3\" , name4=value4; name5=value5, name6= ; name7 = value7; name8 = \" value8\"");
        ParserCursor cursor = new ParserCursor(0, buf.length());
        HeaderElement[] elements = this.parser.parseElements((CharSequence)buf, cursor);
        Assertions.assertEquals((int)3, (int)elements.length);
        Assertions.assertEquals((Object)"name1", (Object)elements[0].getName());
        Assertions.assertEquals((Object)"value1", (Object)elements[0].getValue());
        Assertions.assertEquals((int)2, (int)elements[0].getParameters().length);
        Assertions.assertEquals((Object)"name2", (Object)elements[0].getParameters()[0].getName());
        Assertions.assertNull((Object)elements[0].getParameters()[0].getValue());
        Assertions.assertEquals((Object)"name3", (Object)elements[0].getParameters()[1].getName());
        Assertions.assertEquals((Object)"value3", (Object)elements[0].getParameters()[1].getValue());
        Assertions.assertEquals((Object)"name4", (Object)elements[1].getName());
        Assertions.assertEquals((Object)"value4", (Object)elements[1].getValue());
        Assertions.assertEquals((int)1, (int)elements[1].getParameters().length);
        Assertions.assertEquals((Object)"name5", (Object)elements[1].getParameters()[0].getName());
        Assertions.assertEquals((Object)"value5", (Object)elements[1].getParameters()[0].getValue());
        Assertions.assertEquals((Object)"name6", (Object)elements[2].getName());
        Assertions.assertEquals((Object)"", (Object)elements[2].getValue());
        Assertions.assertEquals((int)2, (int)elements[2].getParameters().length);
        Assertions.assertEquals((Object)"name7", (Object)elements[2].getParameters()[0].getName());
        Assertions.assertEquals((Object)"value7", (Object)elements[2].getParameters()[0].getValue());
        Assertions.assertEquals((Object)"name8", (Object)elements[2].getParameters()[1].getName());
        Assertions.assertEquals((Object)" value8", (Object)elements[2].getParameters()[1].getValue());
    }

    @Test
    void testParseHEEscaped() {
        String headerValue = "test1 =  \"\\\"stuff\\\"\", test2= \"\\\\\", test3 = \"stuff, stuff\"";
        CharArrayBuffer buf = new CharArrayBuffer(64);
        buf.append("test1 =  \"\\\"stuff\\\"\", test2= \"\\\\\", test3 = \"stuff, stuff\"");
        ParserCursor cursor = new ParserCursor(0, buf.length());
        HeaderElement[] elements = this.parser.parseElements((CharSequence)buf, cursor);
        Assertions.assertEquals((int)3, (int)elements.length);
        Assertions.assertEquals((Object)"test1", (Object)elements[0].getName());
        Assertions.assertEquals((Object)"\"stuff\"", (Object)elements[0].getValue());
        Assertions.assertEquals((Object)"test2", (Object)elements[1].getName());
        Assertions.assertEquals((Object)"\\", (Object)elements[1].getValue());
        Assertions.assertEquals((Object)"test3", (Object)elements[2].getName());
        Assertions.assertEquals((Object)"stuff, stuff", (Object)elements[2].getValue());
    }

    @Test
    void testHEFringeCase1() {
        String headerValue = "name1 = value1,";
        CharArrayBuffer buf = new CharArrayBuffer(64);
        buf.append("name1 = value1,");
        ParserCursor cursor = new ParserCursor(0, buf.length());
        HeaderElement[] elements = this.parser.parseElements((CharSequence)buf, cursor);
        Assertions.assertEquals((int)1, (int)elements.length, (String)"Number of elements");
    }

    @Test
    void testHEFringeCase2() {
        String headerValue = "name1 = value1, ";
        CharArrayBuffer buf = new CharArrayBuffer(64);
        buf.append("name1 = value1, ");
        ParserCursor cursor = new ParserCursor(0, buf.length());
        HeaderElement[] elements = this.parser.parseElements((CharSequence)buf, cursor);
        Assertions.assertEquals((int)1, (int)elements.length, (String)"Number of elements");
    }

    @Test
    void testHEFringeCase3() {
        String headerValue = ",, ,, ,";
        CharArrayBuffer buf = new CharArrayBuffer(64);
        buf.append(",, ,, ,");
        ParserCursor cursor = new ParserCursor(0, buf.length());
        HeaderElement[] elements = this.parser.parseElements((CharSequence)buf, cursor);
        Assertions.assertEquals((int)0, (int)elements.length, (String)"Number of elements");
    }

    @Test
    void testNVParse() {
        String s = "test";
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append(s);
        ParserCursor cursor = new ParserCursor(0, s.length());
        NameValuePair param = this.parser.parseNameValuePair((CharSequence)buffer, cursor);
        Assertions.assertEquals((Object)"test", (Object)param.getName());
        Assertions.assertNull((Object)param.getValue());
        Assertions.assertEquals((int)s.length(), (int)cursor.getPos());
        Assertions.assertTrue((boolean)cursor.atEnd());
        s = "test;";
        buffer = new CharArrayBuffer(16);
        buffer.append(s);
        cursor = new ParserCursor(0, s.length());
        param = this.parser.parseNameValuePair((CharSequence)buffer, cursor);
        Assertions.assertEquals((Object)"test", (Object)param.getName());
        Assertions.assertNull((Object)param.getValue());
        Assertions.assertEquals((int)(s.length() - 1), (int)cursor.getPos());
        Assertions.assertFalse((boolean)cursor.atEnd());
        s = "test  ,12";
        buffer = new CharArrayBuffer(16);
        buffer.append(s);
        cursor = new ParserCursor(0, s.length());
        param = this.parser.parseNameValuePair((CharSequence)buffer, cursor);
        Assertions.assertEquals((Object)"test", (Object)param.getName());
        Assertions.assertNull((Object)param.getValue());
        Assertions.assertEquals((int)(s.length() - 3), (int)cursor.getPos());
        Assertions.assertFalse((boolean)cursor.atEnd());
        s = "test=stuff";
        buffer = new CharArrayBuffer(16);
        buffer.append(s);
        cursor = new ParserCursor(0, s.length());
        param = this.parser.parseNameValuePair((CharSequence)buffer, cursor);
        Assertions.assertEquals((Object)"test", (Object)param.getName());
        Assertions.assertEquals((Object)"stuff", (Object)param.getValue());
        Assertions.assertEquals((int)s.length(), (int)cursor.getPos());
        Assertions.assertTrue((boolean)cursor.atEnd());
        s = "   test  =   stuff ";
        buffer = new CharArrayBuffer(16);
        buffer.append(s);
        cursor = new ParserCursor(0, s.length());
        param = this.parser.parseNameValuePair((CharSequence)buffer, cursor);
        Assertions.assertEquals((Object)"test", (Object)param.getName());
        Assertions.assertEquals((Object)"stuff", (Object)param.getValue());
        Assertions.assertEquals((int)s.length(), (int)cursor.getPos());
        Assertions.assertTrue((boolean)cursor.atEnd());
        s = "   test  =   stuff ;1234";
        buffer = new CharArrayBuffer(16);
        buffer.append(s);
        cursor = new ParserCursor(0, s.length());
        param = this.parser.parseNameValuePair((CharSequence)buffer, cursor);
        Assertions.assertEquals((Object)"test", (Object)param.getName());
        Assertions.assertEquals((Object)"stuff", (Object)param.getValue());
        Assertions.assertEquals((int)(s.length() - 5), (int)cursor.getPos());
        Assertions.assertFalse((boolean)cursor.atEnd());
        s = "test  = \"stuff\"";
        buffer = new CharArrayBuffer(16);
        buffer.append(s);
        cursor = new ParserCursor(0, s.length());
        param = this.parser.parseNameValuePair((CharSequence)buffer, cursor);
        Assertions.assertEquals((Object)"test", (Object)param.getName());
        Assertions.assertEquals((Object)"stuff", (Object)param.getValue());
        s = "test  = \"  stuff\\\"\"";
        buffer = new CharArrayBuffer(16);
        buffer.append(s);
        cursor = new ParserCursor(0, s.length());
        param = this.parser.parseNameValuePair((CharSequence)buffer, cursor);
        Assertions.assertEquals((Object)"test", (Object)param.getName());
        Assertions.assertEquals((Object)"  stuff\"", (Object)param.getValue());
        s = "  test";
        buffer = new CharArrayBuffer(16);
        buffer.append(s);
        cursor = new ParserCursor(0, s.length());
        param = this.parser.parseNameValuePair((CharSequence)buffer, cursor);
        Assertions.assertEquals((Object)"test", (Object)param.getName());
        Assertions.assertNull((Object)param.getValue());
        s = "  ";
        buffer = new CharArrayBuffer(16);
        buffer.append(s);
        cursor = new ParserCursor(0, s.length());
        param = this.parser.parseNameValuePair((CharSequence)buffer, cursor);
        Assertions.assertEquals((Object)"", (Object)param.getName());
        Assertions.assertNull((Object)param.getValue());
        s = " = stuff ";
        buffer = new CharArrayBuffer(16);
        buffer.append(s);
        cursor = new ParserCursor(0, s.length());
        param = this.parser.parseNameValuePair((CharSequence)buffer, cursor);
        Assertions.assertEquals((Object)"", (Object)param.getName());
        Assertions.assertEquals((Object)"stuff", (Object)param.getValue());
    }

    @Test
    void testNVParseAll() {
        String s = "test; test1 =  stuff   ; test2 =  \"stuff; stuff\"; test3=\"stuff";
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        buffer.append(s);
        ParserCursor cursor = new ParserCursor(0, s.length());
        NameValuePair[] params = this.parser.parseParameters((CharSequence)buffer, cursor);
        Assertions.assertEquals((Object)"test", (Object)params[0].getName());
        Assertions.assertNull((Object)params[0].getValue());
        Assertions.assertEquals((Object)"test1", (Object)params[1].getName());
        Assertions.assertEquals((Object)"stuff", (Object)params[1].getValue());
        Assertions.assertEquals((Object)"test2", (Object)params[2].getName());
        Assertions.assertEquals((Object)"stuff; stuff", (Object)params[2].getValue());
        Assertions.assertEquals((Object)"test3", (Object)params[3].getName());
        Assertions.assertEquals((Object)"stuff", (Object)params[3].getValue());
        Assertions.assertEquals((int)s.length(), (int)cursor.getPos());
        Assertions.assertTrue((boolean)cursor.atEnd());
        s = "test; test1 =  stuff   ; test2 =  \"stuff; stuff\"; test3=\"stuff\",123";
        buffer = new CharArrayBuffer(16);
        buffer.append(s);
        cursor = new ParserCursor(0, s.length());
        params = this.parser.parseParameters((CharSequence)buffer, cursor);
        Assertions.assertEquals((Object)"test", (Object)params[0].getName());
        Assertions.assertNull((Object)params[0].getValue());
        Assertions.assertEquals((Object)"test1", (Object)params[1].getName());
        Assertions.assertEquals((Object)"stuff", (Object)params[1].getValue());
        Assertions.assertEquals((Object)"test2", (Object)params[2].getName());
        Assertions.assertEquals((Object)"stuff; stuff", (Object)params[2].getValue());
        Assertions.assertEquals((Object)"test3", (Object)params[3].getName());
        Assertions.assertEquals((Object)"stuff", (Object)params[3].getValue());
        Assertions.assertEquals((int)(s.length() - 4), (int)cursor.getPos());
        Assertions.assertFalse((boolean)cursor.atEnd());
        s = "  ";
        buffer = new CharArrayBuffer(16);
        buffer.append(s);
        cursor = new ParserCursor(0, s.length());
        params = this.parser.parseParameters((CharSequence)buffer, cursor);
        Assertions.assertEquals((int)0, (int)params.length);
    }

    @Test
    void testNVParseEscaped() {
        String headerValue = "test1 =  \"\\\"stuff\\\"\"; test2= \"\\\\\"; test3 = \"stuff; stuff\"";
        CharArrayBuffer buf = new CharArrayBuffer(64);
        buf.append("test1 =  \"\\\"stuff\\\"\"; test2= \"\\\\\"; test3 = \"stuff; stuff\"");
        ParserCursor cursor = new ParserCursor(0, buf.length());
        NameValuePair[] params = this.parser.parseParameters((CharSequence)buf, cursor);
        Assertions.assertEquals((int)3, (int)params.length);
        Assertions.assertEquals((Object)"test1", (Object)params[0].getName());
        Assertions.assertEquals((Object)"\"stuff\"", (Object)params[0].getValue());
        Assertions.assertEquals((Object)"test2", (Object)params[1].getName());
        Assertions.assertEquals((Object)"\\", (Object)params[1].getValue());
        Assertions.assertEquals((Object)"test3", (Object)params[2].getName());
        Assertions.assertEquals((Object)"stuff; stuff", (Object)params[2].getValue());
    }
}

