/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.StorageTypeStats;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;

class DatanodeStats {
    private final StorageTypeStatsMap statsMap = new StorageTypeStatsMap();
    private long capacityTotal = 0L;
    private long capacityUsed = 0L;
    private long capacityUsedNonDfs = 0L;
    private long capacityRemaining = 0L;
    private long blockPoolUsed = 0L;
    private int xceiverCount = 0;
    private long cacheCapacity = 0L;
    private long cacheUsed = 0L;
    private int nodesInService = 0;
    private int nodesInServiceXceiverCount = 0;
    private int expiredHeartbeats = 0;

    DatanodeStats() {
    }

    synchronized void add(DatanodeDescriptor node) {
        this.xceiverCount += node.getXceiverCount();
        if (node.isInService()) {
            this.capacityUsed += node.getDfsUsed();
            this.capacityUsedNonDfs += node.getNonDfsUsed();
            this.blockPoolUsed += node.getBlockPoolUsed();
            ++this.nodesInService;
            this.nodesInServiceXceiverCount += node.getXceiverCount();
            this.capacityTotal += node.getCapacity();
            this.capacityRemaining += node.getRemaining();
            this.cacheCapacity += node.getCacheCapacity();
            this.cacheUsed += node.getCacheUsed();
        } else if (node.isDecommissionInProgress() || node.isEnteringMaintenance()) {
            this.cacheCapacity += node.getCacheCapacity();
            this.cacheUsed += node.getCacheUsed();
        }
        HashSet<StorageType> storageTypes = new HashSet<StorageType>();
        for (DatanodeStorageInfo storageInfo : node.getStorageInfos()) {
            if (storageInfo.getState() == DatanodeStorage.State.FAILED) continue;
            this.statsMap.addStorage(storageInfo, node);
            storageTypes.add(storageInfo.getStorageType());
        }
        for (StorageType storageType : storageTypes) {
            this.statsMap.addNode(storageType, node);
        }
    }

    synchronized void subtract(DatanodeDescriptor node) {
        this.xceiverCount -= node.getXceiverCount();
        if (node.isInService()) {
            this.capacityUsed -= node.getDfsUsed();
            this.capacityUsedNonDfs -= node.getNonDfsUsed();
            this.blockPoolUsed -= node.getBlockPoolUsed();
            --this.nodesInService;
            this.nodesInServiceXceiverCount -= node.getXceiverCount();
            this.capacityTotal -= node.getCapacity();
            this.capacityRemaining -= node.getRemaining();
            this.cacheCapacity -= node.getCacheCapacity();
            this.cacheUsed -= node.getCacheUsed();
        } else if (node.isDecommissionInProgress() || node.isEnteringMaintenance()) {
            this.cacheCapacity -= node.getCacheCapacity();
            this.cacheUsed -= node.getCacheUsed();
        }
        HashSet<StorageType> storageTypes = new HashSet<StorageType>();
        for (DatanodeStorageInfo storageInfo : node.getStorageInfos()) {
            if (storageInfo.getState() == DatanodeStorage.State.FAILED) continue;
            this.statsMap.subtractStorage(storageInfo, node);
            storageTypes.add(storageInfo.getStorageType());
        }
        for (StorageType storageType : storageTypes) {
            this.statsMap.subtractNode(storageType, node);
        }
    }

    void incrExpiredHeartbeats() {
        ++this.expiredHeartbeats;
    }

    synchronized Map<StorageType, StorageTypeStats> getStatsMap() {
        return this.statsMap.get();
    }

    synchronized long getCapacityTotal() {
        return this.capacityTotal;
    }

    synchronized long getCapacityUsed() {
        return this.capacityUsed;
    }

    synchronized long getCapacityRemaining() {
        return this.capacityRemaining;
    }

    synchronized long getBlockPoolUsed() {
        return this.blockPoolUsed;
    }

    synchronized int getXceiverCount() {
        return this.xceiverCount;
    }

    synchronized long getCacheCapacity() {
        return this.cacheCapacity;
    }

    synchronized long getCacheUsed() {
        return this.cacheUsed;
    }

    synchronized int getNodesInService() {
        return this.nodesInService;
    }

    synchronized int getNodesInServiceXceiverCount() {
        return this.nodesInServiceXceiverCount;
    }

    synchronized int getExpiredHeartbeats() {
        return this.expiredHeartbeats;
    }

    synchronized float getCapacityRemainingPercent() {
        return DFSUtilClient.getPercentRemaining((long)this.capacityRemaining, (long)this.capacityTotal);
    }

    synchronized float getPercentBlockPoolUsed() {
        return DFSUtilClient.getPercentUsed((long)this.blockPoolUsed, (long)this.capacityTotal);
    }

    synchronized long getCapacityUsedNonDFS() {
        return this.capacityUsedNonDfs;
    }

    synchronized float getCapacityUsedPercent() {
        return DFSUtilClient.getPercentUsed((long)this.capacityUsed, (long)this.capacityTotal);
    }

    static final class StorageTypeStatsMap {
        private Map<StorageType, StorageTypeStats> storageTypeStatsMap = new EnumMap<StorageType, StorageTypeStats>(StorageType.class);

        StorageTypeStatsMap() {
        }

        private Map<StorageType, StorageTypeStats> get() {
            return new EnumMap<StorageType, StorageTypeStats>(this.storageTypeStatsMap);
        }

        private void addNode(StorageType storageType, DatanodeDescriptor node) {
            StorageTypeStats storageTypeStats = this.storageTypeStatsMap.get(storageType);
            if (storageTypeStats == null) {
                storageTypeStats = new StorageTypeStats();
                this.storageTypeStatsMap.put(storageType, storageTypeStats);
            }
            storageTypeStats.addNode(node);
        }

        private void addStorage(DatanodeStorageInfo info, DatanodeDescriptor node) {
            StorageTypeStats storageTypeStats = this.storageTypeStatsMap.get(info.getStorageType());
            if (storageTypeStats == null) {
                storageTypeStats = new StorageTypeStats();
                this.storageTypeStatsMap.put(info.getStorageType(), storageTypeStats);
            }
            storageTypeStats.addStorage(info, node);
        }

        private void subtractStorage(DatanodeStorageInfo info, DatanodeDescriptor node) {
            StorageTypeStats storageTypeStats = this.storageTypeStatsMap.get(info.getStorageType());
            if (storageTypeStats != null) {
                storageTypeStats.subtractStorage(info, node);
            }
        }

        private void subtractNode(StorageType storageType, DatanodeDescriptor node) {
            StorageTypeStats storageTypeStats = this.storageTypeStatsMap.get(storageType);
            if (storageTypeStats != null) {
                storageTypeStats.subtractNode(node);
                if (storageTypeStats.getNodesInService() == 0) {
                    this.storageTypeStatsMap.remove(storageType);
                }
            }
        }
    }
}

