/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.zookeeper.ZKListener;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionServerAddressTracker
extends ZKListener {
    private static final Logger LOG = LoggerFactory.getLogger(RegionServerAddressTracker.class);
    private volatile List<ServerName> regionServers = Collections.emptyList();
    private final Abortable abortable;

    public RegionServerAddressTracker(ZKWatcher watcher, Abortable abortable) {
        super(watcher);
        this.abortable = abortable;
        watcher.registerListener(this);
        this.loadRegionServerList();
    }

    private void loadRegionServerList() {
        List<String> names;
        try {
            names = ZKUtil.listChildrenAndWatchForNewChildren(this.watcher, this.watcher.getZNodePaths().rsZNode);
        }
        catch (KeeperException e) {
            LOG.error("failed to list region servers", (Throwable)e);
            this.abortable.abort("failed to list region servers", e);
            return;
        }
        this.regionServers = CollectionUtils.isEmpty(names) ? Collections.emptyList() : names.stream().map(ServerName::parseServerName).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    @Override
    public void nodeChildrenChanged(String path) {
        if (path.equals(this.watcher.getZNodePaths().rsZNode)) {
            this.loadRegionServerList();
        }
    }

    public List<ServerName> getRegionServers() {
        return this.regionServers;
    }
}

