/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.com.lmax.disruptor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.hbase.shaded.com.lmax.disruptor.ExceptionHandler;

public final class IgnoreExceptionHandler
implements ExceptionHandler<Object> {
    private static final Logger LOGGER = Logger.getLogger(IgnoreExceptionHandler.class.getName());
    private final Logger logger;

    public IgnoreExceptionHandler() {
        this.logger = LOGGER;
    }

    public IgnoreExceptionHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void handleEventException(Throwable ex, long sequence, Object event) {
        this.logger.log(Level.INFO, "Exception processing: " + sequence + " " + event, ex);
    }

    @Override
    public void handleOnStartException(Throwable ex) {
        this.logger.log(Level.INFO, "Exception during onStart()", ex);
    }

    @Override
    public void handleOnShutdownException(Throwable ex) {
        this.logger.log(Level.INFO, "Exception during onShutdown()", ex);
    }
}

