/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.mob.MobCell;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MobFile {
    private HStoreFile sf;

    protected MobFile() {
    }

    protected MobFile(HStoreFile sf) {
        this.sf = sf;
    }

    public StoreFileScanner getScanner() throws IOException {
        ArrayList<HStoreFile> sfs = new ArrayList<HStoreFile>();
        sfs.add(this.sf);
        List<StoreFileScanner> sfScanners = StoreFileScanner.getScannersForStoreFiles(sfs, false, true, false, false, this.sf.getMaxMemStoreTS());
        return sfScanners.get(0);
    }

    public MobCell readCell(Cell search, boolean cacheMobBlocks) throws IOException {
        return this.readCell(search, cacheMobBlocks, this.sf.getMaxMemStoreTS());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MobCell readCell(Cell search, boolean cacheMobBlocks, long readPt) throws IOException {
        StoreFileScanner scanner = null;
        boolean succ = false;
        try {
            List<StoreFileScanner> sfScanners = StoreFileScanner.getScannersForStoreFiles(Collections.singletonList(this.sf), cacheMobBlocks, true, false, false, readPt);
            if (!sfScanners.isEmpty() && (scanner = sfScanners.get(0)).seek(search)) {
                MobCell mobCell = new MobCell(scanner.peek(), scanner);
                succ = true;
                MobCell mobCell2 = mobCell;
                return mobCell2;
            }
            MobCell mobCell = null;
            return mobCell;
        }
        finally {
            if (scanner != null && !succ) {
                scanner.close();
            }
        }
    }

    public String getFileName() {
        return this.sf.getPath().getName();
    }

    public void open() throws IOException {
        this.sf.initReader();
    }

    public void close() throws IOException {
        if (this.sf != null) {
            this.sf.closeStoreFile(false);
            this.sf = null;
        }
    }

    public static MobFile create(FileSystem fs, Path path, Configuration conf, CacheConfig cacheConf) throws IOException {
        HStoreFile sf = new HStoreFile(fs, path, conf, cacheConf, BloomType.NONE, true);
        return new MobFile(sf);
    }
}

