/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptor;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptorFactory;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerImpl;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.shaded.com.google.errorprone.annotations.RestrictedApi;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RpcRetryingCallerFactory {
    public static final String CUSTOM_CALLER_CONF_KEY = "hbase.rpc.callerfactory.class";
    private final ConnectionConfiguration connectionConf;
    private final RetryingCallerInterceptor interceptor;
    private final int startLogErrorsCnt;
    private final MetricsConnection metrics;

    public RpcRetryingCallerFactory(Configuration conf, ConnectionConfiguration connectionConf) {
        this(conf, connectionConf, RetryingCallerInterceptorFactory.NO_OP_INTERCEPTOR, null);
    }

    public RpcRetryingCallerFactory(Configuration conf, ConnectionConfiguration connectionConf, RetryingCallerInterceptor interceptor, MetricsConnection metrics) {
        this.connectionConf = connectionConf;
        this.startLogErrorsCnt = conf.getInt("hbase.client.start.log.errors.counter", 5);
        this.interceptor = interceptor;
        this.metrics = metrics;
    }

    public <T> RpcRetryingCaller<T> newCaller(int rpcTimeout) {
        return new RpcRetryingCallerImpl(this.connectionConf.getPauseMillis(), this.connectionConf.getPauseMillisForServerOverloaded(), this.connectionConf.getRetriesNumber(), this.interceptor, this.startLogErrorsCnt, rpcTimeout, this.metrics);
    }

    public <T> RpcRetryingCaller<T> newCaller() {
        return new RpcRetryingCallerImpl(this.connectionConf.getPauseMillis(), this.connectionConf.getPauseMillisForServerOverloaded(), this.connectionConf.getRetriesNumber(), this.interceptor, this.startLogErrorsCnt, this.connectionConf.getRpcTimeout(), this.metrics);
    }

    @RestrictedApi(explanation="Should only be called on process initialization", link="", allowedOnPath=".*/(HRegionServer|LoadIncrementalHFiles|SecureBulkLoadClient)\\.java")
    public static RpcRetryingCallerFactory instantiate(Configuration configuration, MetricsConnection metrics) {
        return RpcRetryingCallerFactory.instantiate(configuration, new ConnectionConfiguration(configuration), metrics);
    }

    public static RpcRetryingCallerFactory instantiate(Configuration configuration, ConnectionConfiguration connectionConf, MetricsConnection metrics) {
        return RpcRetryingCallerFactory.instantiate(configuration, connectionConf, RetryingCallerInterceptorFactory.NO_OP_INTERCEPTOR, null, metrics);
    }

    public static RpcRetryingCallerFactory instantiate(Configuration configuration, ConnectionConfiguration connectionConf, ServerStatisticTracker stats, MetricsConnection metrics) {
        return RpcRetryingCallerFactory.instantiate(configuration, connectionConf, RetryingCallerInterceptorFactory.NO_OP_INTERCEPTOR, stats, metrics);
    }

    public static RpcRetryingCallerFactory instantiate(Configuration configuration, ConnectionConfiguration connectionConf, RetryingCallerInterceptor interceptor, ServerStatisticTracker stats, MetricsConnection metrics) {
        String clazzName = RpcRetryingCallerFactory.class.getName();
        String rpcCallerFactoryClazz = configuration.get(CUSTOM_CALLER_CONF_KEY, clazzName);
        RpcRetryingCallerFactory factory = rpcCallerFactoryClazz.equals(clazzName) ? new RpcRetryingCallerFactory(configuration, connectionConf, interceptor, metrics) : (RpcRetryingCallerFactory)ReflectionUtils.instantiateWithCustomCtor(rpcCallerFactoryClazz, new Class[]{Configuration.class, ConnectionConfiguration.class}, new Object[]{configuration, connectionConf});
        return factory;
    }
}

