/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@XmlRootElement(name="Region")
@InterfaceAudience.Private
public class TableRegionModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String table;
    private long id;
    private byte[] startKey;
    private byte[] endKey;
    private String location;

    public TableRegionModel() {
    }

    public TableRegionModel(String table, long id, byte[] startKey, byte[] endKey) {
        this(table, id, startKey, endKey, null);
    }

    public TableRegionModel(String table, long id, byte[] startKey, byte[] endKey, String location) {
        this.table = table;
        this.id = id;
        this.startKey = startKey;
        this.endKey = endKey;
        this.location = location;
    }

    @XmlAttribute
    public String getName() {
        TableName tableName;
        byte[] tableNameAsBytes = Bytes.toBytes((String)this.table);
        byte[] nameAsBytes = HRegionInfo.createRegionName((TableName)tableName, (byte[])this.startKey, (long)this.id, (!(tableName = TableName.valueOf((byte[])tableNameAsBytes)).isSystemTable() ? 1 : 0) != 0);
        return Bytes.toString((byte[])nameAsBytes);
    }

    @XmlAttribute
    public long getId() {
        return this.id;
    }

    @XmlAttribute
    public byte[] getStartKey() {
        return this.startKey;
    }

    @XmlAttribute
    public byte[] getEndKey() {
        return this.endKey;
    }

    @XmlAttribute
    public String getLocation() {
        return this.location;
    }

    public void setName(String name) {
        String[] split = name.split(",");
        this.table = split[0];
        this.startKey = Bytes.toBytes((String)split[1]);
        String tail = split[2];
        split = tail.split("\\.");
        this.id = Long.parseLong(split[0]);
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setStartKey(byte[] startKey) {
        this.startKey = startKey;
    }

    public void setEndKey(byte[] endKey) {
        this.endKey = endKey;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(" [\n  id=");
        sb.append(this.id);
        sb.append("\n  startKey='");
        sb.append(Bytes.toString((byte[])this.startKey));
        sb.append("'\n  endKey='");
        sb.append(Bytes.toString((byte[])this.endKey));
        if (this.location != null) {
            sb.append("'\n  location='");
            sb.append(this.location);
        }
        sb.append("'\n]\n");
        return sb.toString();
    }
}

