/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.rest.RESTServlet;
import org.apache.hadoop.hbase.rest.RowSpec;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MultiRowResultReader {
    private static final Logger LOG = LoggerFactory.getLogger(MultiRowResultReader.class);
    private Result[] results;

    public MultiRowResultReader(String tableName, Collection<RowSpec> rowspecs, Filter filter, boolean cacheBlocks) throws IOException {
        block20: {
            try (Table table = RESTServlet.getInstance().getTable(tableName);){
                ArrayList<Get> gets = new ArrayList<Get>(rowspecs.size());
                for (RowSpec rowspec : rowspecs) {
                    Get get = new Get(rowspec.getRow());
                    if (rowspec.hasColumns()) {
                        for (byte[] col : rowspec.getColumns()) {
                            byte[][] split = CellUtil.parseColumn((byte[])col);
                            if (split.length == 1) {
                                get.addFamily(split[0]);
                                continue;
                            }
                            if (split.length == 2) {
                                get.addColumn(split[0], split[1]);
                                continue;
                            }
                            throw new IllegalArgumentException("Invalid column specifier.");
                        }
                    }
                    get.setTimeRange(rowspec.getStartTime(), rowspec.getEndTime());
                    get.readVersions(rowspec.getMaxVersions());
                    if (filter != null) {
                        get.setFilter(filter);
                    }
                    get.setCacheBlocks(cacheBlocks);
                    gets.add(get);
                }
                this.results = table.get(gets);
            }
            catch (DoNotRetryIOException e) {
                LOG.warn(StringUtils.stringifyException((Throwable)e));
                if (!(e instanceof AccessDeniedException)) break block20;
                throw e;
            }
        }
    }

    public Result[] getResults() {
        return this.results;
    }
}

