/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.mavibot;

import java.io.IOException;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.Cursor;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyTupleArrayCursor<K, V>
extends AbstractCursor<org.apache.directory.api.ldap.model.cursor.Tuple<K, V>> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)Loggers.CURSOR_LOG.getName());
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private final Cursor<V, V> wrapped;
    private final K key;
    private org.apache.directory.api.ldap.model.cursor.Tuple<K, V> returnedTuple = new org.apache.directory.api.ldap.model.cursor.Tuple();
    private boolean valueAvailable;

    public KeyTupleArrayCursor(BTree<V, V> arrayTree, K key) {
        this.key = key;
        try {
            this.wrapped = arrayTree.browse();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating KeyTupleArrayCursor {}", (Object)this);
        }
    }

    private void clearValue() {
        this.returnedTuple.setKey(this.key);
        this.returnedTuple.setValue(null);
        this.valueAvailable = false;
    }

    public boolean available() {
        return this.valueAvailable;
    }

    public void beforeKey(K key) throws Exception {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_446, (Object[])new Object[0]));
    }

    public void afterKey(K key) throws Exception {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_446, (Object[])new Object[0]));
    }

    public void beforeValue(K key, V value) throws Exception {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_446, (Object[])new Object[0]));
    }

    public void afterValue(K key, V value) throws Exception {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_446, (Object[])new Object[0]));
    }

    public void before(org.apache.directory.api.ldap.model.cursor.Tuple<K, V> element) throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_446, (Object[])new Object[0]));
    }

    public void after(org.apache.directory.api.ldap.model.cursor.Tuple<K, V> element) throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_446, (Object[])new Object[0]));
    }

    public void beforeFirst() throws LdapException, CursorException {
    }

    public void afterLast() throws LdapException, CursorException {
    }

    public boolean first() throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_446, (Object[])new Object[0]));
    }

    public boolean last() throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_446, (Object[])new Object[0]));
    }

    public boolean previous() throws LdapException, CursorException {
        this.checkNotClosed("previous()");
        try {
            if (this.wrapped.hasPrev()) {
                Tuple t = this.wrapped.prev();
                this.returnedTuple.setKey(this.key);
                this.returnedTuple.setValue(t.getKey());
                this.valueAvailable = true;
                return true;
            }
            this.clearValue();
            return false;
        }
        catch (IOException e) {
            throw new CursorException((Throwable)e);
        }
    }

    public boolean next() throws LdapException, CursorException {
        this.checkNotClosed("next()");
        try {
            if (this.wrapped.hasNext()) {
                Tuple t = this.wrapped.next();
                this.returnedTuple.setKey(this.key);
                this.returnedTuple.setValue(t.getKey());
                this.valueAvailable = true;
                return true;
            }
            this.clearValue();
            return false;
        }
        catch (IOException e) {
            throw new CursorException((Throwable)e);
        }
    }

    public org.apache.directory.api.ldap.model.cursor.Tuple<K, V> get() throws CursorException {
        this.checkNotClosed("get()");
        if (this.valueAvailable) {
            return this.returnedTuple;
        }
        throw new InvalidCursorPositionException();
    }

    public void close() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing KeyTupleArrayCursor {}", (Object)this);
        }
        if (this.wrapped != null) {
            this.wrapped.close();
        }
        super.close();
    }

    public void close(Exception reason) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing KeyTupleArrayCursor {}", (Object)this);
        }
        if (this.wrapped != null) {
            this.wrapped.close();
        }
        super.close(reason);
    }

    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("KeyTupleArrayCursor (");
        if (this.available()) {
            sb.append("available)");
        } else {
            sb.append("absent)");
        }
        sb.append("#").append(this.key);
        sb.append(" :\n");
        sb.append(this.wrapped.toString());
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

