/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdfs.util.RateLimiter;
import org.apache.hadoop.util.FakeTimer;
import org.apache.hadoop.util.Timer;
import org.junit.Assert;
import org.junit.Test;

public class TestRateLimiter {
    private static final double EPSILON = 1.0 / (double)TimeUnit.SECONDS.toNanos(1L);

    @Test
    public void testRateLimiter() {
        FakeTimer timer = new FakeTimer();
        LinkedList<Long> sleepTimesNanos = new LinkedList<Long>();
        LinkedList<Long> advanceTimerNanos = new LinkedList<Long>();
        TestingRateLimiter limiter = new TestingRateLimiter(timer, 10.0, sleepTimesNanos, advanceTimerNanos);
        long nanos100ms = TimeUnit.MILLISECONDS.toNanos(100L);
        Assert.assertEquals((double)0.0, (double)limiter.acquire(), (double)EPSILON);
        Assert.assertTrue((boolean)sleepTimesNanos.isEmpty());
        advanceTimerNanos.add(nanos100ms);
        Assert.assertEquals((double)0.1, (double)limiter.acquire(), (double)EPSILON);
        Assert.assertEquals((long)1L, (long)sleepTimesNanos.size());
        TestRateLimiter.assertNextValue(sleepTimesNanos, nanos100ms);
        advanceTimerNanos.add(nanos100ms / 2L);
        advanceTimerNanos.add(nanos100ms / 2L);
        Assert.assertEquals((double)0.1, (double)limiter.acquire(), (double)EPSILON);
        Assert.assertEquals((long)2L, (long)sleepTimesNanos.size());
        TestRateLimiter.assertNextValue(sleepTimesNanos, nanos100ms);
        TestRateLimiter.assertNextValue(sleepTimesNanos, nanos100ms / 2L);
        timer.advanceNanos(nanos100ms * 2L);
        Assert.assertEquals((double)0.0, (double)limiter.acquire(), (double)EPSILON);
        Assert.assertTrue((boolean)sleepTimesNanos.isEmpty());
        advanceTimerNanos.add(nanos100ms);
        Assert.assertEquals((double)0.1, (double)limiter.acquire(), (double)EPSILON);
        Assert.assertEquals((long)1L, (long)sleepTimesNanos.size());
        TestRateLimiter.assertNextValue(sleepTimesNanos, nanos100ms);
    }

    private static void assertNextValue(Queue<Long> queue, long expected) {
        Long value = queue.poll();
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((long)expected, (long)value);
    }

    private static class TestingRateLimiter
    extends RateLimiter {
        private final FakeTimer fakeTimer;
        private final Queue<Long> sleepTimesNanos;
        private final Queue<Long> advanceTimerNanos;

        TestingRateLimiter(FakeTimer fakeTimer, double maxOpsPerSecond, Queue<Long> sleepTimesNanos, Queue<Long> advanceTimerNanos) {
            super((Timer)fakeTimer, maxOpsPerSecond);
            this.fakeTimer = fakeTimer;
            this.sleepTimesNanos = sleepTimesNanos;
            this.advanceTimerNanos = advanceTimerNanos;
        }

        boolean sleep(long sleepTimeNanos) {
            this.sleepTimesNanos.offer(sleepTimeNanos);
            Long advanceNanos = this.advanceTimerNanos.poll();
            if (advanceNanos == null) {
                Assert.fail((String)"Unexpected sleep; no timer advance value found");
            }
            this.fakeTimer.advanceNanos(advanceNanos.longValue());
            return false;
        }
    }
}

