/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileDiff;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileDiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileWithSnapshotFeature;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;

public class TestFileWithSnapshotFeature {
    private static final int BLOCK_SIZE = 1024;
    private static final short REPL_3 = 3;
    private static final short REPL_1 = 1;

    @Test
    public void testUpdateQuotaAndCollectBlocks() {
        FileDiffList diffs = new FileDiffList();
        FileWithSnapshotFeature sf = new FileWithSnapshotFeature(diffs);
        FileDiff diff = (FileDiff)Mockito.mock(FileDiff.class);
        BlockStoragePolicySuite bsps = (BlockStoragePolicySuite)Mockito.mock(BlockStoragePolicySuite.class);
        BlockStoragePolicy bsp = (BlockStoragePolicy)Mockito.mock(BlockStoragePolicy.class);
        BlockInfo[] blocks = new BlockInfo[]{new BlockInfoContiguous(new Block(1L, 1024L, 1L), 1)};
        BlockManager bm = (BlockManager)Mockito.mock(BlockManager.class);
        INodeFile file = (INodeFile)Mockito.mock(INodeFile.class);
        Mockito.when((Object)file.getFileWithSnapshotFeature()).thenReturn((Object)sf);
        Mockito.when((Object)file.getBlocks()).thenReturn((Object)blocks);
        Mockito.when((Object)file.getStoragePolicyID()).thenReturn((Object)1);
        Whitebox.setInternalState((Object)file, (String)"header", (Object)0x1000000000000L);
        Mockito.when((Object)file.getPreferredBlockReplication()).thenReturn((Object)1);
        Mockito.when((Object)bsps.getPolicy(Mockito.anyByte())).thenReturn((Object)bsp);
        INode.BlocksMapUpdateInfo collectedBlocks = (INode.BlocksMapUpdateInfo)Mockito.mock(INode.BlocksMapUpdateInfo.class);
        ArrayList removedINodes = new ArrayList();
        INode.ReclaimContext ctx = new INode.ReclaimContext(bsps, collectedBlocks, removedINodes, null);
        sf.updateQuotaAndCollectBlocks(ctx, file, diff);
        QuotaCounts counts = ctx.quotaDelta().getCountsCopy();
        Assert.assertEquals((long)0L, (long)counts.getStorageSpace());
        Assert.assertTrue((boolean)counts.getTypeSpaces().allLessOrEqual(0L));
        INodeFile snapshotINode = (INodeFile)Mockito.mock(INodeFile.class);
        Whitebox.setInternalState((Object)snapshotINode, (String)"header", (Object)0x3000000000000L);
        Whitebox.setInternalState((Object)diff, (String)"snapshotINode", (Object)snapshotINode);
        Mockito.when((Object)diff.getSnapshotINode()).thenReturn((Object)snapshotINode);
        Mockito.when((Object)bsp.chooseStorageTypes((short)1)).thenReturn((Object)Lists.newArrayList((Object[])new StorageType[]{StorageType.SSD}));
        Mockito.when((Object)bsp.chooseStorageTypes((short)3)).thenReturn((Object)Lists.newArrayList((Object[])new StorageType[]{StorageType.DISK}));
        blocks[0].setReplication((short)3);
        sf.updateQuotaAndCollectBlocks(ctx, file, diff);
        counts = ctx.quotaDelta().getCountsCopy();
        Assert.assertEquals((long)2048L, (long)counts.getStorageSpace());
        Assert.assertEquals((long)1024L, (long)counts.getTypeSpaces().get((Enum)StorageType.DISK));
        Assert.assertEquals((long)-1024L, (long)counts.getTypeSpaces().get((Enum)StorageType.SSD));
    }
}

