/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.apache.hadoop.hdfs.server.namenode.AuditLogger;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.top.TopAuditLogger;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAuditLogger {
    private static final Logger LOG = LoggerFactory.getLogger(TestAuditLogger.class);
    private static final short TEST_PERMISSION = 428;

    @Before
    public void setup() {
        DummyAuditLogger.initialized = false;
        DummyAuditLogger.logCount = 0;
        DummyAuditLogger.remoteAddr = null;
        HdfsConfiguration conf = new HdfsConfiguration();
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuditLogger() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.audit.loggers", DummyAuditLogger.class.getName());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitClusterUp();
            Assert.assertTrue((boolean)DummyAuditLogger.initialized);
            DummyAuditLogger.resetLogCount();
            DistributedFileSystem fs = cluster.getFileSystem();
            long time = System.currentTimeMillis();
            fs.setTimes(new Path("/"), time, time);
            Assert.assertEquals((long)1L, (long)DummyAuditLogger.logCount);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisableTopAuditLogger() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.top.enabled", false);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitClusterUp();
            List auditLoggers = cluster.getNameNode().getNamesystem().getAuditLoggers();
            for (AuditLogger auditLogger : auditLoggers) {
                Assert.assertFalse((String)"top audit logger is still hooked in after it is disabled", (boolean)(auditLogger instanceof TopAuditLogger));
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWebHdfsAuditLogger() throws IOException, URISyntaxException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.audit.loggers", DummyAuditLogger.class.getName());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        GetOpParam.Op op = GetOpParam.Op.GETFILESTATUS;
        try {
            cluster.waitClusterUp();
            Assert.assertTrue((boolean)DummyAuditLogger.initialized);
            URI uri = new URI("http", NetUtils.getHostPortString((InetSocketAddress)cluster.getNameNode().getHttpAddress()), "/webhdfs/v1/", op.toQueryString(), null);
            HttpURLConnection conn = (HttpURLConnection)uri.toURL().openConnection();
            conn.setRequestMethod(op.getType().toString());
            conn.connect();
            Assert.assertEquals((long)200L, (long)conn.getResponseCode());
            conn.disconnect();
            Assert.assertEquals((long)1L, (long)DummyAuditLogger.logCount);
            Assert.assertEquals((Object)"127.0.0.1", (Object)DummyAuditLogger.remoteAddr);
            conn = (HttpURLConnection)uri.toURL().openConnection();
            conn.setRequestMethod(op.getType().toString());
            conn.setRequestProperty("X-Forwarded-For", "1.1.1.1");
            conn.connect();
            Assert.assertEquals((long)200L, (long)conn.getResponseCode());
            conn.disconnect();
            Assert.assertEquals((long)2L, (long)DummyAuditLogger.logCount);
            Assert.assertEquals((Object)"127.0.0.1", (Object)DummyAuditLogger.remoteAddr);
            conf.set("hadoop.proxyservers", "127.0.0.1");
            ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
            conn = (HttpURLConnection)uri.toURL().openConnection();
            conn.setRequestMethod(op.getType().toString());
            conn.setRequestProperty("X-Forwarded-For", "1.1.1.1");
            conn.connect();
            Assert.assertEquals((long)200L, (long)conn.getResponseCode());
            conn.disconnect();
            Assert.assertEquals((long)3L, (long)DummyAuditLogger.logCount);
            Assert.assertEquals((Object)"1.1.1.1", (Object)DummyAuditLogger.remoteAddr);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuditLoggerWithSetPermission() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.audit.loggers", DummyAuditLogger.class.getName());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitClusterUp();
            Assert.assertTrue((boolean)DummyAuditLogger.initialized);
            DummyAuditLogger.resetLogCount();
            DistributedFileSystem fs = cluster.getFileSystem();
            long time = System.currentTimeMillis();
            Path p = new Path("/");
            fs.setTimes(p, time, time);
            fs.setPermission(p, new FsPermission(428));
            Assert.assertEquals((long)428L, (long)DummyAuditLogger.foundPermission);
            Assert.assertEquals((long)2L, (long)DummyAuditLogger.logCount);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuditLoggerWithCallContext() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("hadoop.caller.context.enabled", true);
        conf.setInt("hadoop.caller.context.max.size", 128);
        conf.setInt("hadoop.caller.context.signature.max.size", 40);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        GenericTestUtils.LogCapturer auditlog = GenericTestUtils.LogCapturer.captureLogs((Log)FSNamesystem.auditLog);
        try {
            cluster.waitClusterUp();
            DistributedFileSystem fs = cluster.getFileSystem();
            long time = System.currentTimeMillis();
            Path p = new Path("/");
            Assert.assertNull((Object)CallerContext.getCurrent());
            CallerContext context = new CallerContext.Builder("setTimes").build();
            CallerContext.setCurrent((CallerContext)context);
            LOG.info("Set current caller context as {}", (Object)CallerContext.getCurrent());
            fs.setTimes(p, time, time);
            Assert.assertTrue((boolean)auditlog.getOutput().endsWith(String.format("callerContext=setTimes%n", new Object[0])));
            auditlog.clearOutput();
            context = new CallerContext.Builder("setTimes").setSignature("L".getBytes(CallerContext.SIGNATURE_ENCODING)).build();
            CallerContext.setCurrent((CallerContext)context);
            LOG.info("Set current caller context as {}", (Object)CallerContext.getCurrent());
            fs.setTimes(p, time, time);
            Assert.assertTrue((boolean)auditlog.getOutput().endsWith(String.format("callerContext=setTimes:L%n", new Object[0])));
            auditlog.clearOutput();
            String longContext = StringUtils.repeat((String)"foo", (int)100);
            context = new CallerContext.Builder(longContext).setSignature("L".getBytes(CallerContext.SIGNATURE_ENCODING)).build();
            CallerContext.setCurrent((CallerContext)context);
            LOG.info("Set current caller context as {}", (Object)CallerContext.getCurrent());
            fs.setTimes(p, time, time);
            Assert.assertTrue((boolean)auditlog.getOutput().endsWith(String.format("callerContext=%s:L%n", longContext.substring(0, 128))));
            auditlog.clearOutput();
            context = new CallerContext.Builder("").setSignature("L".getBytes(CallerContext.SIGNATURE_ENCODING)).build();
            CallerContext.setCurrent((CallerContext)context);
            LOG.info("Set empty caller context");
            fs.setTimes(p, time, time);
            Assert.assertFalse((boolean)auditlog.getOutput().contains("callerContext="));
            auditlog.clearOutput();
            context = new CallerContext.Builder("setTimes").setSignature("L".getBytes(CallerContext.SIGNATURE_ENCODING)).build();
            CallerContext.setCurrent((CallerContext)context);
            LOG.info("Set current caller context as {}", (Object)CallerContext.getCurrent());
            Thread child = new Thread(new Runnable((FileSystem)fs, p, time){
                final /* synthetic */ FileSystem val$fs;
                final /* synthetic */ Path val$p;
                final /* synthetic */ long val$time;
                {
                    this.val$fs = fileSystem;
                    this.val$p = path;
                    this.val$time = l;
                }

                @Override
                public void run() {
                    try {
                        this.val$fs.setTimes(this.val$p, this.val$time, this.val$time);
                    }
                    catch (IOException e) {
                        Assert.fail((String)("Unexpected exception found." + e));
                    }
                }
            });
            child.start();
            try {
                child.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assert.assertTrue((boolean)auditlog.getOutput().endsWith(String.format("callerContext=setTimes:L%n", new Object[0])));
            auditlog.clearOutput();
            final CallerContext childContext = new CallerContext.Builder("setPermission").setSignature("L".getBytes(CallerContext.SIGNATURE_ENCODING)).build();
            LOG.info("Set current caller context as {}", (Object)CallerContext.getCurrent());
            child = new Thread(new Runnable((FileSystem)fs, p){
                final /* synthetic */ FileSystem val$fs;
                final /* synthetic */ Path val$p;
                {
                    this.val$fs = fileSystem;
                    this.val$p = path;
                }

                @Override
                public void run() {
                    try {
                        CallerContext.setCurrent((CallerContext)childContext);
                        this.val$fs.setPermission(this.val$p, new FsPermission(777));
                    }
                    catch (IOException e) {
                        Assert.fail((String)("Unexpected exception found." + e));
                    }
                }
            });
            child.start();
            try {
                child.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assert.assertTrue((boolean)auditlog.getOutput().endsWith(String.format("callerContext=setPermission:L%n", new Object[0])));
            auditlog.clearOutput();
            context = new CallerContext.Builder("mkdirs").setSignature(CallerContext.getCurrent().getSignature()).build();
            CallerContext.setCurrent((CallerContext)context);
            LOG.info("Set current caller context as {}", (Object)CallerContext.getCurrent());
            fs.mkdirs(new Path("/reuse-context-signature"));
            Assert.assertTrue((boolean)auditlog.getOutput().endsWith(String.format("callerContext=mkdirs:L%n", new Object[0])));
            auditlog.clearOutput();
            context = new CallerContext.Builder("setTimes").setSignature(new byte[41]).build();
            CallerContext.setCurrent((CallerContext)context);
            LOG.info("Set current caller context as {}", (Object)CallerContext.getCurrent());
            fs.setTimes(p, time, time);
            Assert.assertTrue((boolean)auditlog.getOutput().endsWith(String.format("callerContext=setTimes%n", new Object[0])));
            auditlog.clearOutput();
            context = new CallerContext.Builder("setTimes").setSignature(null).build();
            CallerContext.setCurrent((CallerContext)context);
            LOG.info("Set current caller context as {}", (Object)CallerContext.getCurrent());
            fs.setTimes(p, time, time);
            Assert.assertTrue((boolean)auditlog.getOutput().endsWith(String.format("callerContext=setTimes%n", new Object[0])));
            auditlog.clearOutput();
            context = new CallerContext.Builder("mkdirs").setSignature("".getBytes(CallerContext.SIGNATURE_ENCODING)).build();
            CallerContext.setCurrent((CallerContext)context);
            LOG.info("Set current caller context as {}", (Object)CallerContext.getCurrent());
            fs.mkdirs(new Path("/empty-signature"));
            Assert.assertTrue((boolean)auditlog.getOutput().endsWith(String.format("callerContext=mkdirs%n", new Object[0])));
            auditlog.clearOutput();
            context = new CallerContext.Builder(null).build();
            CallerContext.setCurrent((CallerContext)context);
            LOG.info("Set current caller context as {}", (Object)CallerContext.getCurrent());
            fs.mkdirs(new Path("/empty-signature"));
            Assert.assertFalse((boolean)auditlog.getOutput().contains("callerContext="));
            auditlog.clearOutput();
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuditLogWithAclFailure() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        conf.set("dfs.namenode.audit.loggers", DummyAuditLogger.class.getName());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitClusterUp();
            FSDirectory dir = cluster.getNamesystem().getFSDirectory();
            FSDirectory mockedDir = (FSDirectory)Mockito.spy((Object)dir);
            AccessControlException ex = new AccessControlException();
            ((FSDirectory)Mockito.doThrow((Throwable)ex).when((Object)mockedDir)).getPermissionChecker();
            cluster.getNamesystem().setFSDirectory(mockedDir);
            Assert.assertTrue((boolean)DummyAuditLogger.initialized);
            DummyAuditLogger.resetLogCount();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path p = new Path("/");
            ArrayList acls = Lists.newArrayList();
            try {
                fs.getAclStatus(p);
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
            try {
                fs.setAcl(p, (List)acls);
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
            try {
                fs.removeAcl(p);
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
            try {
                fs.removeDefaultAcl(p);
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
            try {
                fs.removeAclEntries(p, (List)acls);
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
            try {
                fs.modifyAclEntries(p, (List)acls);
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
            Assert.assertEquals((long)6L, (long)DummyAuditLogger.logCount);
            Assert.assertEquals((long)6L, (long)DummyAuditLogger.unsuccessfulCount);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testAuditLogForAcls() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        conf.set("dfs.namenode.audit.loggers", DummyAuditLogger.class.getName());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitClusterUp();
            Assert.assertTrue((boolean)DummyAuditLogger.initialized);
            DistributedFileSystem fs = cluster.getFileSystem();
            Path p = new Path("/debug.log");
            DFSTestUtil.createFile((FileSystem)fs, p, 1024L, (short)1, 0L);
            DummyAuditLogger.resetLogCount();
            fs.getAclStatus(p);
            Assert.assertEquals((long)1L, (long)DummyAuditLogger.logCount);
            DFSTestUtil.FsShellRun("-getfacl " + p.toUri().getPath(), 0, null, (Configuration)conf);
            Assert.assertEquals((long)2L, (long)DummyAuditLogger.logCount);
            ArrayList acls = Lists.newArrayList();
            acls.add(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL));
            acls.add(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "user1", FsAction.ALL));
            acls.add(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE));
            acls.add(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.EXECUTE));
            fs.setAcl(p, (List)acls);
            Assert.assertEquals((long)3L, (long)DummyAuditLogger.logCount);
            DFSTestUtil.FsShellRun("-getfacl " + p.toUri().getPath(), 0, null, (Configuration)conf);
            Assert.assertEquals((long)5L, (long)DummyAuditLogger.logCount);
            fs.removeAcl(p);
            Assert.assertEquals((long)6L, (long)DummyAuditLogger.logCount);
            ArrayList aclsToRemove = Lists.newArrayList();
            aclsToRemove.add(AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "user1", FsAction.ALL));
            fs.removeAclEntries(p, (List)aclsToRemove);
            fs.removeDefaultAcl(p);
            Assert.assertEquals((long)8L, (long)DummyAuditLogger.logCount);
            DFSTestUtil.FsShellRun("-getfacl " + p.toUri().getPath(), 0, null, (Configuration)conf);
            Assert.assertEquals((long)9L, (long)DummyAuditLogger.logCount);
            Assert.assertEquals((long)0L, (long)DummyAuditLogger.unsuccessfulCount);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBrokenLogger() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.audit.loggers", BrokenAuditLogger.class.getName());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitClusterUp();
            DistributedFileSystem fs = cluster.getFileSystem();
            long time = System.currentTimeMillis();
            fs.setTimes(new Path("/"), time, time);
            Assert.fail((String)"Expected exception due to broken audit logger.");
        }
        catch (RemoteException remoteException) {
        }
        finally {
            cluster.shutdown();
        }
    }

    static {
        GenericTestUtils.setLogLevel((Logger)LOG, (Level)Level.ALL);
    }

    public static class BrokenAuditLogger
    implements AuditLogger {
        public void initialize(Configuration conf) {
        }

        public void logAuditEvent(boolean succeeded, String userName, InetAddress addr, String cmd, String src, String dst, FileStatus stat) {
            throw new RuntimeException("uh oh");
        }
    }

    public static class DummyAuditLogger
    implements AuditLogger {
        static boolean initialized;
        static int logCount;
        static int unsuccessfulCount;
        static short foundPermission;
        static String remoteAddr;

        public void initialize(Configuration conf) {
            initialized = true;
        }

        public static void resetLogCount() {
            logCount = 0;
            unsuccessfulCount = 0;
        }

        public void logAuditEvent(boolean succeeded, String userName, InetAddress addr, String cmd, String src, String dst, FileStatus stat) {
            remoteAddr = addr.getHostAddress();
            ++logCount;
            if (!succeeded) {
                ++unsuccessfulCount;
            }
            if (stat != null) {
                foundPermission = stat.getPermission().toShort();
            }
        }
    }
}

