/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.http.HttpServer2;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestDatanodeHttpXFrame {
    private MiniDFSCluster cluster = null;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @After
    public void cleanUp() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testDataNodeXFrameOptionsEnabled() throws Exception {
        boolean xFrameEnabled = true;
        this.cluster = TestDatanodeHttpXFrame.createCluster(xFrameEnabled, null);
        HttpURLConnection conn = TestDatanodeHttpXFrame.getConn(this.cluster);
        String xfoHeader = conn.getHeaderField("X-FRAME-OPTIONS");
        Assert.assertTrue((String)"X-FRAME-OPTIONS is absent in the header", (xfoHeader != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)xfoHeader.endsWith(HttpServer2.XFrameOption.SAMEORIGIN.toString()));
    }

    @Test
    public void testNameNodeXFrameOptionsDisabled() throws Exception {
        boolean xFrameEnabled = false;
        this.cluster = TestDatanodeHttpXFrame.createCluster(xFrameEnabled, null);
        HttpURLConnection conn = TestDatanodeHttpXFrame.getConn(this.cluster);
        String xfoHeader = conn.getHeaderField("X-FRAME-OPTIONS");
        Assert.assertTrue((String)"unexpected X-FRAME-OPTION in header", (xfoHeader == null ? 1 : 0) != 0);
    }

    @Test
    public void testDataNodeXFramewithInvalidOptions() throws Exception {
        this.exception.expect(IllegalArgumentException.class);
        this.cluster = TestDatanodeHttpXFrame.createCluster(false, "Hadoop");
    }

    private static MiniDFSCluster createCluster(boolean enabled, String value) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.xframe.enabled", enabled);
        if (value != null) {
            conf.set("dfs.xframe.value", value);
        }
        MiniDFSCluster dfsCluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        dfsCluster.waitActive();
        return dfsCluster;
    }

    private static HttpURLConnection getConn(MiniDFSCluster dfsCluster) throws IOException {
        DataNode datanode = dfsCluster.getDataNodes().get(0);
        URL newURL = new URL("http://localhost:" + datanode.getInfoPort());
        HttpURLConnection conn = (HttpURLConnection)newURL.openConnection();
        conn.connect();
        return conn;
    }
}

