/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.blockmanagement.StorageTypeStats;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.util.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.Timeout;
import org.mortbay.util.ajax.JSON;

public class TestBlockStatsMXBean {
    private MiniDFSCluster cluster;
    @Rule
    public Timeout globalTimeout = new Timeout(300000);

    @Before
    public void setup() throws IOException {
        int i;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setTimeDuration("dfs.datanode.disk.check.min.gap", 0L, TimeUnit.MILLISECONDS);
        this.cluster = null;
        StorageType[][] types = new StorageType[6][];
        for (i = 0; i < 3; ++i) {
            types[i] = new StorageType[]{StorageType.RAM_DISK, StorageType.DISK};
        }
        for (i = 3; i < 5; ++i) {
            types[i] = new StorageType[]{StorageType.RAM_DISK, StorageType.ARCHIVE};
        }
        types[5] = new StorageType[]{StorageType.RAM_DISK, StorageType.ARCHIVE, StorageType.ARCHIVE};
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(6).storageTypes(types).storagesPerDatanode(3).build();
        this.cluster.waitActive();
    }

    @After
    public void tearDown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testStorageTypeStats() throws Exception {
        Map storageTypeStatsMap = this.cluster.getNamesystem().getBlockManager().getStorageTypeStats();
        Assert.assertTrue((boolean)storageTypeStatsMap.containsKey(StorageType.RAM_DISK));
        Assert.assertTrue((boolean)storageTypeStatsMap.containsKey(StorageType.DISK));
        Assert.assertTrue((boolean)storageTypeStatsMap.containsKey(StorageType.ARCHIVE));
        StorageTypeStats storageTypeStats = (StorageTypeStats)storageTypeStatsMap.get(StorageType.RAM_DISK);
        Assert.assertEquals((long)6L, (long)storageTypeStats.getNodesInService());
        storageTypeStats = (StorageTypeStats)storageTypeStatsMap.get(StorageType.DISK);
        Assert.assertEquals((long)3L, (long)storageTypeStats.getNodesInService());
        storageTypeStats = (StorageTypeStats)storageTypeStatsMap.get(StorageType.ARCHIVE);
        Assert.assertEquals((long)3L, (long)storageTypeStats.getNodesInService());
    }

    protected static String readOutput(URL url) throws IOException {
        StringBuilder out = new StringBuilder();
        InputStream in = url.openConnection().getInputStream();
        byte[] buffer = new byte[65536];
        int len = in.read(buffer);
        while (len > 0) {
            out.append(new String(buffer, 0, len));
            len = in.read(buffer);
        }
        return out.toString();
    }

    @Test
    public void testStorageTypeStatsJMX() throws Exception {
        URL baseUrl = new URL(this.cluster.getHttpUri(0));
        String result = TestBlockStatsMXBean.readOutput(new URL(baseUrl, "/jmx"));
        Map stat = (Map)JSON.parse((String)result);
        Object[] beans = (Object[])stat.get("beans");
        Map blockStats = null;
        for (Object bean : beans) {
            Map map = (Map)bean;
            if (!map.get("name").equals("Hadoop:service=NameNode,name=BlockStats")) continue;
            blockStats = map;
        }
        Assert.assertNotNull(blockStats);
        Object[] storageTypeStatsList = (Object[])blockStats.get("StorageTypeStats");
        Assert.assertNotNull((Object)storageTypeStatsList);
        Assert.assertEquals((long)3L, (long)storageTypeStatsList.length);
        HashSet<String> typesPresent = new HashSet<String>();
        for (Object obj : storageTypeStatsList) {
            Map entry = (Map)obj;
            String storageType = (String)entry.get("key");
            Map storageTypeStats = (Map)entry.get("value");
            typesPresent.add(storageType);
            if (storageType.equals("ARCHIVE") || storageType.equals("DISK")) {
                Assert.assertEquals((Object)3L, storageTypeStats.get("nodesInService"));
                continue;
            }
            if (storageType.equals("RAM_DISK")) {
                Assert.assertEquals((Object)6L, storageTypeStats.get("nodesInService"));
                continue;
            }
            Assert.fail();
        }
        Assert.assertTrue((boolean)typesPresent.contains("ARCHIVE"));
        Assert.assertTrue((boolean)typesPresent.contains("DISK"));
        Assert.assertTrue((boolean)typesPresent.contains("RAM_DISK"));
    }

    @Test
    public void testStorageTypeStatsWhenStorageFailed() throws Exception {
        if (Shell.WINDOWS) {
            throw new AssumptionViolatedException("Expected Unix-like platform");
        }
        DFSTestUtil.createFile((FileSystem)this.cluster.getFileSystem(), new Path("/blockStatsFile1"), 1024L, (short)1, 0L);
        Map storageTypeStatsMap = this.cluster.getNamesystem().getBlockManager().getStorageTypeStats();
        StorageTypeStats storageTypeStats = (StorageTypeStats)storageTypeStatsMap.get(StorageType.RAM_DISK);
        Assert.assertEquals((long)6L, (long)storageTypeStats.getNodesInService());
        storageTypeStats = (StorageTypeStats)storageTypeStatsMap.get(StorageType.DISK);
        Assert.assertEquals((long)3L, (long)storageTypeStats.getNodesInService());
        storageTypeStats = (StorageTypeStats)storageTypeStatsMap.get(StorageType.ARCHIVE);
        Assert.assertEquals((long)3L, (long)storageTypeStats.getNodesInService());
        String dataDir = this.cluster.getDataDirectory();
        File dn1ArcVol1 = new File(dataDir, "data2");
        File dn2ArcVol1 = new File(dataDir, "data5");
        File dn3ArcVol1 = new File(dataDir, "data8");
        DataNodeTestUtils.injectDataDirFailure(dn1ArcVol1);
        DataNodeTestUtils.injectDataDirFailure(dn2ArcVol1);
        DataNodeTestUtils.injectDataDirFailure(dn3ArcVol1);
        try {
            DFSTestUtil.createFile((FileSystem)this.cluster.getFileSystem(), new Path("/blockStatsFile2"), 1024L, (short)1, 0L);
            Assert.fail((String)"Should throw exception, becuase no DISK storage available");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("could only be replicated to 0 nodes instead"));
        }
        Thread.sleep(6000L);
        storageTypeStatsMap = this.cluster.getNamesystem().getBlockManager().getStorageTypeStats();
        Assert.assertFalse((String)"StorageTypeStatsMap should not contain DISK Storage type", (boolean)storageTypeStatsMap.containsKey(StorageType.DISK));
        DataNodeTestUtils.restoreDataDirFromFailure(dn1ArcVol1);
        DataNodeTestUtils.restoreDataDirFromFailure(dn2ArcVol1);
        DataNodeTestUtils.restoreDataDirFromFailure(dn3ArcVol1);
        for (int i = 0; i < 3; ++i) {
            this.cluster.restartDataNode(0, true);
        }
        Thread.sleep(6000L);
        storageTypeStatsMap = this.cluster.getNamesystem().getBlockManager().getStorageTypeStats();
        storageTypeStats = (StorageTypeStats)storageTypeStatsMap.get(StorageType.RAM_DISK);
        Assert.assertEquals((long)6L, (long)storageTypeStats.getNodesInService());
        storageTypeStats = (StorageTypeStats)storageTypeStatsMap.get(StorageType.DISK);
        Assert.assertEquals((long)3L, (long)storageTypeStats.getNodesInService());
        storageTypeStats = (StorageTypeStats)storageTypeStatsMap.get(StorageType.ARCHIVE);
        Assert.assertEquals((long)3L, (long)storageTypeStats.getNodesInService());
    }
}

