/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import java.util.HashSet;
import java.util.Set;
import org.apache.directory.api.ldap.model.schema.syntaxCheckers.TelephoneNumberSyntaxChecker;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacsimileTelephoneNumberSyntaxChecker
extends TelephoneNumberSyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(FacsimileTelephoneNumberSyntaxChecker.class);
    private static final String TWO_DIMENSIONAL = "twoDimensional";
    private static final String FINE_RESOLUTION = "fineResolution";
    private static final String UNLIMITED_LENGTH = "unlimitedLength";
    private static final String B4_LENGTH = "b4Length";
    private static final String A3_LENGTH = "a3Width";
    private static final String B4_WIDTH = "b4Width";
    private static final String UNCOMPRESSED = "uncompressed";
    private static Set<String> faxParameters = new HashSet<String>();

    public FacsimileTelephoneNumberSyntaxChecker() {
        this.setOid("1.3.6.1.4.1.1466.115.121.1.22");
    }

    @Override
    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        if (strValue.length() == 0) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        int dollarPos = strValue.indexOf(36);
        if (dollarPos == -1) {
            boolean result = super.isValidSyntax(strValue);
            if (result) {
                LOG.debug("Syntax valid for '{}'", value);
            } else {
                LOG.debug("Syntax invalid for '{}'", value);
            }
            return result;
        }
        if (dollarPos > 0) {
            if (!super.isValidSyntax(strValue.substring(0, dollarPos - 1))) {
                LOG.debug("Syntax invalid for '{}'", value);
                return false;
            }
            HashSet<String> paramsSeen = new HashSet<String>();
            while (dollarPos > 0) {
                String faxParam = null;
                int newDollar = strValue.indexOf(36, dollarPos + 1);
                faxParam = newDollar == -1 ? strValue.substring(dollarPos + 1) : strValue.substring(dollarPos + 1, newDollar);
                if (faxParam.length() == 0) {
                    LOG.debug("Syntax invalid for '{}'", value);
                    return false;
                }
                if (!faxParameters.contains(faxParam = Strings.toLowerCase((String)faxParam))) {
                    LOG.debug("Syntax invalid for '{}'", value);
                    return false;
                }
                if (paramsSeen.contains(faxParam)) {
                    LOG.debug("Syntax invalid for '{}'", value);
                    return false;
                }
                paramsSeen.add(faxParam);
                dollarPos = newDollar;
            }
            LOG.debug("Syntax valid for '{}'", value);
            return true;
        }
        LOG.debug("Syntax invalid for '{}'", value);
        return false;
    }

    static {
        faxParameters.add(Strings.toLowerCase((String)TWO_DIMENSIONAL));
        faxParameters.add(Strings.toLowerCase((String)FINE_RESOLUTION));
        faxParameters.add(Strings.toLowerCase((String)UNLIMITED_LENGTH));
        faxParameters.add(Strings.toLowerCase((String)B4_LENGTH));
        faxParameters.add(Strings.toLowerCase((String)A3_LENGTH));
        faxParameters.add(Strings.toLowerCase((String)B4_WIDTH));
        faxParameters.add(Strings.toLowerCase((String)UNCOMPRESSED));
    }
}

