/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.asyncfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.asyncfs.AsyncFSTestBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.hadoop.ipc.RemoteException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MiscTests.class, MediumTests.class})
public class TestOverwriteFileUnderConstruction
extends AsyncFSTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestOverwriteFileUnderConstruction.class);
    private static FileSystem FS;
    @Rule
    public final TestName name = new TestName();

    @BeforeClass
    public static void setUp() throws Exception {
        TestOverwriteFileUnderConstruction.startMiniDFSCluster(3);
        FS = CLUSTER.getFileSystem();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TestOverwriteFileUnderConstruction.shutdownMiniDFSCluster();
    }

    @Test
    public void testNotOverwrite() throws IOException {
        Path file = new Path("/" + this.name.getMethodName());
        try (FSDataOutputStream out1 = FS.create(file);){
            try {
                FS.create(file, false);
                Assert.fail((String)"Should fail as there is a file with the same name which is being written");
            }
            catch (RemoteException e) {
                MatcherAssert.assertThat((Object)e.unwrapRemoteException(), (Matcher)CoreMatchers.instanceOf(AlreadyBeingCreatedException.class));
            }
        }
    }

    @Test
    public void testOverwrite() throws IOException {
        Path file = new Path("/" + this.name.getMethodName());
        FSDataOutputStream out1 = FS.create(file);
        FSDataOutputStream out2 = FS.create(file, true);
        out1.write(2);
        out2.write(1);
        try {
            out1.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (RemoteException e) {
            MatcherAssert.assertThat((Object)e.unwrapRemoteException(), (Matcher)CoreMatchers.instanceOf(LeaseExpiredException.class));
        }
        out2.close();
        try (FSDataInputStream in = FS.open(file);){
            Assert.assertEquals((long)1L, (long)in.read());
            Assert.assertEquals((long)-1L, (long)in.read());
        }
    }
}

