/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.IOException;
import java.util.Comparator;
import jdbm.btree.BTree;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyBTreeCursor<E>
extends AbstractCursor<E> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)Loggers.CURSOR_LOG.getName());
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private final Tuple tuple = new Tuple();
    private final BTree btree;
    private final Comparator<E> comparator;
    private boolean valueAvailable;
    private TupleBrowser browser;

    public KeyBTreeCursor(BTree btree, Comparator<E> comparator) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating KeyBTreeCursor {}", (Object)this);
        }
        this.btree = btree;
        this.comparator = comparator;
    }

    private void clearValue() {
        this.tuple.setKey(null);
        this.tuple.setValue(null);
        this.valueAvailable = false;
    }

    public boolean available() {
        return this.valueAvailable;
    }

    public void before(E element) throws LdapException, CursorException {
        this.checkNotClosed("before()");
        try {
            this.browser = this.btree.browse(element);
        }
        catch (IOException e) {
            throw new CursorException((Throwable)e);
        }
        this.clearValue();
    }

    public void after(E element) throws LdapException, CursorException {
        try {
            this.browser = this.btree.browse(element);
            while (this.browser.getNext(this.tuple)) {
                this.checkNotClosed("after()");
                Object next = this.tuple.getKey();
                int nextCompared = this.comparator.compare(next, element);
                if (nextCompared <= 0) continue;
                this.browser.getPrevious(this.tuple);
                this.clearValue();
                return;
            }
            this.clearValue();
        }
        catch (IOException e) {
            throw new CursorException((Throwable)e);
        }
    }

    public void beforeFirst() throws LdapException, CursorException {
        this.checkNotClosed("beforeFirst()");
        try {
            this.browser = this.btree.browse();
            this.clearValue();
        }
        catch (IOException e) {
            throw new CursorException((Throwable)e);
        }
    }

    public void afterLast() throws LdapException, CursorException {
        this.checkNotClosed("afterLast()");
        try {
            this.browser = this.btree.browse(null);
        }
        catch (IOException e) {
            throw new CursorException((Throwable)e);
        }
    }

    public boolean first() throws LdapException, CursorException {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() throws LdapException, CursorException {
        this.afterLast();
        return this.previous();
    }

    public boolean previous() throws LdapException, CursorException {
        this.checkNotClosed("previous()");
        try {
            if (this.browser == null) {
                this.browser = this.btree.browse(null);
            }
            if (this.browser.getPrevious(this.tuple)) {
                this.valueAvailable = true;
                return true;
            }
            this.clearValue();
            return false;
        }
        catch (IOException e) {
            throw new CursorException((Throwable)e);
        }
    }

    public boolean next() throws LdapException, CursorException {
        this.checkNotClosed("next()");
        try {
            if (this.browser == null) {
                this.browser = this.btree.browse();
            }
            if (this.browser.getNext(this.tuple)) {
                this.valueAvailable = true;
                return true;
            }
            this.clearValue();
            return false;
        }
        catch (IOException e) {
            throw new CursorException((Throwable)e);
        }
    }

    public E get() throws CursorException {
        this.checkNotClosed("get()");
        if (this.valueAvailable) {
            return (E)this.tuple.getKey();
        }
        throw new InvalidCursorPositionException();
    }

    public void close() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing KeyBTreeCursor {}", (Object)this);
        }
        super.close();
    }

    public void close(Exception cause) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing KeyBTreeCursor {}", (Object)this);
        }
        super.close(cause);
    }
}

