/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.avltree.avl;

import java.util.Iterator;
import org.apache.directory.server.core.avltree.avl.AvlNode;

final class AvlTreeIterator<T extends Comparable<T>>
implements Iterator<T> {
    private AvlNode<T> root;
    private AvlNode<T> next = null;
    private boolean initial = true;

    public AvlTreeIterator(AvlNode<T> root) {
        this.root = root;
        this.find_next();
    }

    @Override
    public boolean hasNext() {
        return this.next != null || this.initial && this.root != null;
    }

    @Override
    public T next() {
        T value = this.next == null ? null : (T)this.next.value;
        this.find_next();
        return value;
    }

    public void find_next() {
        if (this.next == null) {
            if (this.root == null || !this.initial) {
                return;
            }
            this.initial = false;
            this.next = this.root;
            while (this.next.left != null) {
                this.next = this.next.left;
            }
        } else if (this.next.right != null) {
            this.next = this.next.right;
            while (this.next.left != null) {
                this.next = this.next.left;
            }
        } else {
            AvlNode parent = this.next.parent;
            while (parent != null && parent.left != this.next) {
                this.next = parent;
                parent = this.next.parent;
            }
            this.next = parent;
        }
    }

    @Override
    public void remove() {
        assert (false) : "not supported";
    }
}

