/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicRLESparseResourceAllocation
extends RLESparseResourceAllocation {
    private static final Logger LOG = LoggerFactory.getLogger(PeriodicRLESparseResourceAllocation.class);
    private long timePeriod;

    public PeriodicRLESparseResourceAllocation(ResourceCalculator resourceCalculator, Long timePeriod) {
        super(resourceCalculator);
        this.timePeriod = timePeriod;
    }

    public PeriodicRLESparseResourceAllocation(ResourceCalculator resourceCalculator) {
        this(resourceCalculator, (Long)86400000L);
    }

    @VisibleForTesting
    public PeriodicRLESparseResourceAllocation(RLESparseResourceAllocation rleVector, Long timePeriod) {
        super(rleVector.getCumulative(), rleVector.getResourceCalculator());
        this.timePeriod = timePeriod;
        long delta = this.getEarliestStartTime() % timePeriod - this.getEarliestStartTime();
        this.shift(delta);
        ArrayList toRemove = new ArrayList();
        TreeMap toAdd = new TreeMap();
        for (Map.Entry entry : this.cumulativeCapacity.entrySet()) {
            if ((Long)entry.getKey() <= timePeriod) continue;
            toRemove.add(entry.getKey());
            if (entry.getValue() == null) continue;
            toAdd.put(timePeriod, entry.getValue());
            long prev = (Long)entry.getKey() % timePeriod;
            toAdd.put(prev, this.getCapacityAtTime(prev));
            toAdd.put(0L, entry.getValue());
        }
        for (Long l : toRemove) {
            this.cumulativeCapacity.remove(l);
        }
        this.cumulativeCapacity.putAll(toAdd);
    }

    @Override
    public Resource getCapacityAtTime(long tick) {
        long convertedTime = tick % this.timePeriod;
        return super.getCapacityAtTime(convertedTime);
    }

    @Override
    public boolean addInterval(ReservationInterval interval, Resource resource) {
        long startTime = interval.getStartTime();
        long endTime = interval.getEndTime();
        if (startTime >= 0L && endTime > startTime && endTime <= this.timePeriod) {
            return super.addInterval(interval, resource);
        }
        LOG.info("Cannot set capacity beyond end time: " + this.timePeriod + " was (" + interval.toString() + ")");
        return false;
    }

    @Override
    public boolean removeInterval(ReservationInterval interval, Resource resource) {
        long endTime;
        long startTime = interval.getStartTime();
        if (!Resources.fitsIn((Resource)resource, (Resource)this.getMinimumCapacityInInterval(new ReservationInterval(startTime, (endTime = interval.getEndTime()) - 1L)))) {
            LOG.info("Request to remove more resources than what is available");
            return false;
        }
        if (startTime >= 0L && endTime > startTime && endTime <= this.timePeriod) {
            return super.removeInterval(interval, resource);
        }
        LOG.info("Interval extends beyond the end time " + this.timePeriod);
        return false;
    }

    @Override
    public Resource getMaximumPeriodicCapacity(long tick, long period) {
        Resource maxResource = period < this.timePeriod ? super.getMaximumPeriodicCapacity(tick % this.timePeriod, period) : super.getCapacityAtTime(tick % this.timePeriod);
        return maxResource;
    }

    public long getTimePeriod() {
        return this.timePeriod;
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("Period: ").append(this.timePeriod).append("\n").append(super.toString());
        if (super.isEmpty()) {
            ret.append(" no allocations\n");
        }
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RLESparseResourceAllocation getRangeOverlapping(long start, long end) {
        TreeMap<Long, Resource> unrolledMap = new TreeMap<Long, Resource>();
        this.readLock.lock();
        try {
            long relativeStart = start >= 0L ? start % this.timePeriod : 0L;
            NavigableMap<Long, Resource> cumulativeMap = this.getCumulative();
            Long previous = cumulativeMap.floorKey(relativeStart);
            previous = previous != null ? previous : 0L;
            for (long i = 0L; i <= 1L + (end - start) / this.timePeriod; ++i) {
                for (Map.Entry e : cumulativeMap.entrySet()) {
                    long curKey = (Long)e.getKey() + i * this.timePeriod;
                    if (curKey < previous || start + curKey - relativeStart > end) continue;
                    unrolledMap.put(curKey, (Resource)e.getValue());
                }
            }
            RLESparseResourceAllocation rle = new RLESparseResourceAllocation(unrolledMap, this.getResourceCalculator());
            rle.shift(start - relativeStart);
            RLESparseResourceAllocation rLESparseResourceAllocation = rle;
            return rLESparseResourceAllocation;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

