/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.org.glassfish.jersey.client;

import java.security.AccessController;
import java.security.KeyStore;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hbase.thirdparty.javax.ws.rs.client.ClientBuilder;
import org.apache.hbase.thirdparty.javax.ws.rs.core.Configuration;
import org.apache.hbase.thirdparty.org.glassfish.jersey.client.ClientConfig;
import org.apache.hbase.thirdparty.org.glassfish.jersey.client.JerseyClient;
import org.apache.hbase.thirdparty.org.glassfish.jersey.client.SslContextClientBuilder;
import org.apache.hbase.thirdparty.org.glassfish.jersey.client.innate.inject.NonInjectionManager;
import org.apache.hbase.thirdparty.org.glassfish.jersey.client.spi.ClientBuilderListener;
import org.apache.hbase.thirdparty.org.glassfish.jersey.client.spi.ConnectorProvider;
import org.apache.hbase.thirdparty.org.glassfish.jersey.internal.ServiceFinder;
import org.apache.hbase.thirdparty.org.glassfish.jersey.internal.config.ExternalPropertiesConfigurationFactory;
import org.apache.hbase.thirdparty.org.glassfish.jersey.internal.util.ReflectionHelper;
import org.apache.hbase.thirdparty.org.glassfish.jersey.model.internal.RankedComparator;
import org.apache.hbase.thirdparty.org.glassfish.jersey.model.internal.RankedProvider;

public class JerseyClientBuilder
extends ClientBuilder {
    private final ClientConfig config;
    private HostnameVerifier hostnameVerifier;
    private final SslContextClientBuilder sslContextClientBuilder = new SslContextClientBuilder();
    private static final List<ClientBuilderListener> CLIENT_BUILDER_LISTENERS;

    public static JerseyClient createClient() {
        return new JerseyClientBuilder().build();
    }

    public static JerseyClient createClient(Configuration configuration) {
        return new JerseyClientBuilder().withConfig(configuration).build();
    }

    public JerseyClientBuilder() {
        this.config = new ClientConfig();
        JerseyClientBuilder.init(this);
    }

    private static void init(ClientBuilder builder) {
        for (ClientBuilderListener listener : CLIENT_BUILDER_LISTENERS) {
            listener.onNewBuilder(builder);
        }
    }

    @Override
    public JerseyClientBuilder sslContext(SSLContext sslContext) {
        this.sslContextClientBuilder.sslContext(sslContext);
        return this;
    }

    @Override
    public JerseyClientBuilder keyStore(KeyStore keyStore, char[] password) {
        this.sslContextClientBuilder.keyStore(keyStore, password);
        return this;
    }

    @Override
    public JerseyClientBuilder trustStore(KeyStore trustStore) {
        this.sslContextClientBuilder.trustStore(trustStore);
        return this;
    }

    @Override
    public JerseyClientBuilder hostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    @Override
    public ClientBuilder executorService(ExecutorService executorService) {
        this.config.executorService(executorService);
        return this;
    }

    @Override
    public ClientBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.config.scheduledExecutorService(scheduledExecutorService);
        return this;
    }

    @Override
    public ClientBuilder connectTimeout(long timeout, TimeUnit unit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Negative timeout.");
        }
        this.property("org.apache.hbase.thirdparty.jersey.config.client.connectTimeout", Math.toIntExact(unit.toMillis(timeout)));
        return this;
    }

    @Override
    public ClientBuilder readTimeout(long timeout, TimeUnit unit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Negative timeout.");
        }
        this.property("org.apache.hbase.thirdparty.jersey.config.client.readTimeout", Math.toIntExact(unit.toMillis(timeout)));
        return this;
    }

    @Override
    public JerseyClient build() {
        ExternalPropertiesConfigurationFactory.configure(this.config);
        this.setConnectorFromProperties();
        return new JerseyClient((Configuration)this.config, this.sslContextClientBuilder, this.hostnameVerifier, null);
    }

    private void setConnectorFromProperties() {
        Object connectorClass = this.config.getProperty("org.apache.hbase.thirdparty.jersey.config.client.connector.provider");
        if (connectorClass != null) {
            if (String.class.isInstance(connectorClass)) {
                Class clazz = AccessController.doPrivileged(ReflectionHelper.classForNamePA((String)connectorClass));
                ConnectorProvider connectorProvider = (ConnectorProvider)new NonInjectionManager().justCreate(clazz);
                this.config.connectorProvider(connectorProvider);
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public ClientConfig getConfiguration() {
        return this.config;
    }

    @Override
    public JerseyClientBuilder property(String name, Object value) {
        this.config.property(name, value);
        return this;
    }

    @Override
    public JerseyClientBuilder register(Class<?> componentClass) {
        this.config.register((Class)componentClass);
        return this;
    }

    @Override
    public JerseyClientBuilder register(Class<?> componentClass, int priority) {
        this.config.register((Class)componentClass, priority);
        return this;
    }

    @Override
    public JerseyClientBuilder register(Class<?> componentClass, Class<?> ... contracts) {
        this.config.register((Class)componentClass, (Class[])contracts);
        return this;
    }

    @Override
    public JerseyClientBuilder register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.config.register((Class)componentClass, (Map)contracts);
        return this;
    }

    @Override
    public JerseyClientBuilder register(Object component) {
        this.config.register(component);
        return this;
    }

    @Override
    public JerseyClientBuilder register(Object component, int priority) {
        this.config.register(component, priority);
        return this;
    }

    @Override
    public JerseyClientBuilder register(Object component, Class<?> ... contracts) {
        this.config.register(component, (Class[])contracts);
        return this;
    }

    @Override
    public JerseyClientBuilder register(Object component, Map<Class<?>, Integer> contracts) {
        this.config.register(component, (Map)contracts);
        return this;
    }

    @Override
    public JerseyClientBuilder withConfig(Configuration config) {
        this.config.loadFrom(config);
        return this;
    }

    static {
        LinkedList<RankedProvider<ClientBuilderListener>> listeners = new LinkedList<RankedProvider<ClientBuilderListener>>();
        for (ClientBuilderListener listener : ServiceFinder.find(ClientBuilderListener.class)) {
            listeners.add(new RankedProvider<ClientBuilderListener>(listener));
        }
        listeners.sort(new RankedComparator(RankedComparator.Order.ASCENDING));
        LinkedList sortedList = new LinkedList();
        for (RankedProvider rankedProvider : listeners) {
            sortedList.add(rankedProvider.getProvider());
        }
        CLIENT_BUILDER_LISTENERS = Collections.unmodifiableList(sortedList);
    }
}

